/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.core.type.filter;

import io.basc.framework.core.type.ClassMetadata;
import io.basc.framework.core.type.classreading.MetadataReader;
import io.basc.framework.core.type.classreading.MetadataReaderFactory;
import io.basc.framework.core.type.filter.TypeFilter;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import java.io.IOException;

public abstract class AbstractTypeHierarchyTraversingFilter
implements TypeFilter {
    private static Logger logger = LoggerFactory.getLogger(AbstractTypeHierarchyTraversingFilter.class);
    private final boolean considerInherited;
    private final boolean considerInterfaces;

    protected AbstractTypeHierarchyTraversingFilter(boolean considerInherited, boolean considerInterfaces) {
        this.considerInherited = considerInherited;
        this.considerInterfaces = considerInterfaces;
    }

    @Override
    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        ClassMetadata metadata;
        block15: {
            String superClassName;
            if (this.matchSelf(metadataReader)) {
                return true;
            }
            metadata = metadataReader.getClassMetadata();
            if (this.matchClassName(metadata.getClassName())) {
                return true;
            }
            if (this.considerInherited && (superClassName = metadata.getSuperClassName()) != null) {
                Boolean superClassMatch = this.matchSuperClass(superClassName);
                if (superClassMatch != null) {
                    if (superClassMatch.booleanValue()) {
                        return true;
                    }
                } else {
                    try {
                        if (this.match(metadata.getSuperClassName(), metadataReaderFactory)) {
                            return true;
                        }
                    }
                    catch (IOException ex) {
                        if (!logger.isDebugEnabled()) break block15;
                        logger.debug("Could not read superclass [" + metadata.getSuperClassName() + "] of type-filtered class [" + metadata.getClassName() + "]");
                    }
                }
            }
        }
        if (this.considerInterfaces) {
            for (String ifc : metadata.getInterfaceNames()) {
                Boolean interfaceMatch = this.matchInterface(ifc);
                if (interfaceMatch != null) {
                    if (!interfaceMatch.booleanValue()) continue;
                    return true;
                }
                try {
                    if (this.match(ifc, metadataReaderFactory)) {
                        return true;
                    }
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Could not read interface [" + ifc + "] for type-filtered class [" + metadata.getClassName() + "]");
                }
            }
        }
        return false;
    }

    private boolean match(String className, MetadataReaderFactory metadataReaderFactory) throws IOException {
        return this.match(metadataReaderFactory.getMetadataReader(className), metadataReaderFactory);
    }

    protected boolean matchSelf(MetadataReader metadataReader) {
        return false;
    }

    protected boolean matchClassName(String className) {
        return false;
    }

    @Nullable
    protected Boolean matchSuperClass(String superClassName) {
        return null;
    }

    @Nullable
    protected Boolean matchInterface(String interfaceName) {
        return null;
    }
}

