/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.env;

import io.basc.framework.convert.ConversionServiceAware;
import io.basc.framework.convert.lang.ConfigurableConversionService;
import io.basc.framework.convert.lang.ConverterConversionService;
import io.basc.framework.convert.lang.ResourceToPropertiesConverter;
import io.basc.framework.convert.resolve.ResourceResolverConversionService;
import io.basc.framework.convert.resolve.ResourceResolvers;
import io.basc.framework.convert.support.DefaultConversionService;
import io.basc.framework.env.ConfigurableEnvironment;
import io.basc.framework.env.ConfigurableEnvironmentResourceLoader;
import io.basc.framework.env.DefaultEnvironmentProperties;
import io.basc.framework.env.DefaultEnvironmentResourceLoader;
import io.basc.framework.env.Environment;
import io.basc.framework.env.EnvironmentAware;
import io.basc.framework.env.EnvironmentPostProcessor;
import io.basc.framework.event.Observable;
import io.basc.framework.factory.BeanDefinition;
import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.factory.FactoryException;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.factory.support.ConfigServiceLoader;
import io.basc.framework.factory.support.DefaultBeanFactory;
import io.basc.framework.factory.support.ServiceLoaders;
import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourceUtils;
import io.basc.framework.io.resolver.PropertiesResolver;
import io.basc.framework.io.resolver.PropertiesResolvers;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.AntPathMatcher;
import io.basc.framework.util.ConfigurableServiceLoader;
import io.basc.framework.util.DefaultServiceLoader;
import io.basc.framework.util.Optional;
import io.basc.framework.util.Processor;
import io.basc.framework.util.Registration;
import io.basc.framework.util.ServiceLoader;
import io.basc.framework.util.StringMatchers;
import io.basc.framework.util.placeholder.ConfigurablePlaceholderReplacer;
import io.basc.framework.util.placeholder.support.DefaultPlaceholderReplacer;
import io.basc.framework.value.AnyValue;
import io.basc.framework.value.PropertyFactory;
import io.basc.framework.value.PropertyWrapper;
import io.basc.framework.value.Value;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.function.Consumer;

public class DefaultEnvironment
extends DefaultBeanFactory
implements ConfigurableEnvironment,
PropertyWrapper,
Consumer<PropertyFactory>,
Configurable {
    private static final String ENABLE_PREFIX = "io.basc.framework.spi";
    private static Logger logger = LoggerFactory.getLogger(DefaultEnvironment.class);
    private boolean configured = false;
    private final DefaultConversionService conversionService = new DefaultConversionService();
    private final ConfigurableServices<EnvironmentPostProcessor> environmentPostProcessors = new ConfigurableServices<EnvironmentPostProcessor>(EnvironmentPostProcessor.class);
    private final DefaultEnvironmentResourceLoader environmentResourceLoader = new DefaultEnvironmentResourceLoader(this);
    private boolean forceSpi = false;
    private volatile boolean initialized = false;
    private Environment parentEnvironment;
    private final DefaultPlaceholderReplacer placeholderReplacer = new DefaultPlaceholderReplacer();
    private final DefaultEnvironmentProperties properties = new DefaultEnvironmentProperties(this);
    private final PropertiesResolvers propertiesResolvers = new PropertiesResolvers();
    private final ResourceResolvers resourceResolvers = new ResourceResolvers(this.propertiesResolvers, this.conversionService, this.getObservableCharset());
    private final DefaultServiceLoader<Resource> resources = new DefaultServiceLoader();

    public DefaultEnvironment() {
        this.conversionService.addService(new ConverterConversionService(Resource.class, Properties.class, Processor.of(new ResourceToPropertiesConverter(this.resourceResolvers.getPropertiesResolvers()))));
        this.conversionService.addService(new ResourceResolverConversionService(this.resourceResolvers));
        this.registerSingleton(Environment.class.getName(), this);
        this.properties.getPropertyFactories().getFactories().getConsumers().addService(this);
    }

    @Override
    protected void _dependence(Object instance, BeanDefinition definition) throws FactoryException {
        super._dependence(instance, definition);
        if (instance instanceof ConversionServiceAware) {
            ((ConversionServiceAware)instance).setConversionService(this.getConversionService());
        }
    }

    @Override
    public void accept(PropertyFactory instance) {
        if (instance == null) {
            return;
        }
        if (instance instanceof EnvironmentAware) {
            ((EnvironmentAware)((Object)instance)).setEnvironment(this);
        }
    }

    @Override
    public synchronized void configure(ServiceLoaderFactory serviceLoaderFactory) {
        this.configured = true;
        if (!this.environmentResourceLoader.isConfigured()) {
            this.environmentResourceLoader.configure(serviceLoaderFactory);
        }
        if (!this.conversionService.isConfigured()) {
            this.conversionService.configure(serviceLoaderFactory);
        }
        if (!this.properties.isConfigured()) {
            this.properties.configure(serviceLoaderFactory);
        }
        if (!this.placeholderReplacer.isConfigured()) {
            this.placeholderReplacer.configure(this);
        }
        if (!this.environmentPostProcessors.isConfigured()) {
            this.environmentPostProcessors.configure(serviceLoaderFactory);
        }
        if (!this.resourceResolvers.isConfigured()) {
            this.resourceResolvers.configure(serviceLoaderFactory);
        }
        if (!this.propertiesResolvers.isConfigured()) {
            this.propertiesResolvers.configure(serviceLoaderFactory);
        }
    }

    @Override
    protected <S> ServiceLoader<S> getAfterServiceLoader(Class<S> serviceClass) {
        if (this.isForceSpi() || serviceClass.getName().startsWith("io.basc.") || this.useSpi(serviceClass)) {
            return super.getAfterServiceLoader(serviceClass);
        }
        return null;
    }

    @Override
    protected <S> ServiceLoader<S> getBeforeServiceLoader(Class<S> serviceClass) {
        return new ServiceLoaders(new ConfigServiceLoader<S>(serviceClass, this.getProperties(), this), super.getBeforeServiceLoader(serviceClass));
    }

    @Override
    public ConfigurableConversionService getConversionService() {
        return this.conversionService;
    }

    public ConfigurableServices<EnvironmentPostProcessor> getEnvironmentPostProcessors() {
        return this.environmentPostProcessors;
    }

    public Environment getParentEnvironment() {
        return this.parentEnvironment;
    }

    @Override
    public ConfigurablePlaceholderReplacer getPlaceholderReplacer() {
        return this.placeholderReplacer;
    }

    @Override
    public DefaultEnvironmentProperties getProperties() {
        return this.properties;
    }

    @Override
    public PropertiesResolvers getPropertiesResolver() {
        return this.propertiesResolvers;
    }

    @Override
    public ConfigurableEnvironmentResourceLoader getResourceLoader() {
        return this.environmentResourceLoader;
    }

    @Override
    public ResourceResolvers getResourceResolver() {
        return this.resourceResolvers;
    }

    @Override
    public ConfigurableServiceLoader<Resource> getResources() {
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws FactoryException {
        DefaultEnvironment defaultEnvironment = this;
        synchronized (defaultEnvironment) {
            if (this.isInitialized()) {
                throw new FactoryException("The environment has been initialized");
            }
            try {
                super.init();
                logger.debug("Start initializing environment[{}]!", this);
                if (!this.isConfigured()) {
                    this.configure(this);
                }
                for (EnvironmentPostProcessor postProcessor : this.environmentPostProcessors) {
                    try {
                        postProcessor.postProcessEnvironment(this);
                    }
                    catch (Throwable e) {
                        throw new FactoryException("Post process environment[" + postProcessor + "]", e);
                    }
                }
                logger.debug("Started environment[{}]!", this);
            }
            finally {
                this.initialized = true;
            }
        }
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }

    public boolean isForceSpi() {
        return this.forceSpi;
    }

    @Override
    public boolean isInitialized() {
        return super.isInitialized() && this.initialized;
    }

    public void setForceSpi(boolean forceSpi) {
        this.forceSpi = forceSpi;
    }

    public void setParentEnvironment(Environment environment) {
        this.setParentBeanFactory(environment);
        this.parentEnvironment = environment;
        this.placeholderReplacer.setAfterService(environment == null ? null : environment.getPlaceholderReplacer());
        this.conversionService.setAfterService(environment == null ? null : environment.getConversionService());
        this.properties.getPropertyFactories().getFactories().setAfterService(environment == null ? null : environment.getProperties());
        this.environmentResourceLoader.getResourceLoaders().setAfterService(environment == null ? null : environment.getResourceLoader());
        this.resourceResolvers.setAfterService(environment == null ? null : environment.getResourceResolver());
        this.propertiesResolvers.setAfterService(environment == null ? null : environment.getPropertiesResolver());
    }

    @Override
    public Registration source(Observable<Properties> properties) {
        return this.getProperties().getObservable().registerProperties(properties);
    }

    @Override
    public Registration source(Resource resource) {
        return this.source(resource, this.getCharset());
    }

    public Registration source(Resource resource, @Nullable Charset charset) {
        return this.source(resource, this.getPropertiesResolver(), charset);
    }

    @Override
    public Registration source(String location) {
        return ConfigurableEnvironment.super.source(this.replacePlaceholders(location));
    }

    public Registration source(Resource resource, PropertiesResolver propertiesResolver, @Nullable Charset charset) {
        if (resource == null || !resource.exists()) {
            return Registration.EMPTY;
        }
        Registration registration = this.resources.register(resource);
        if (registration.isEmpty()) {
            return registration;
        }
        logger.info("Import resource {}", resource);
        if (propertiesResolver.canResolveProperties(resource)) {
            Optional observable = resource.map(ResourceUtils.toPropertiesConverter(this.getPropertiesResolver()));
            registration = registration.and(this.source((Observable<Properties>)observable));
        }
        return registration;
    }

    protected boolean useSpi(Class<?> serviceClass) {
        String[] prefixs = this.getProperties().getAsObject(ENABLE_PREFIX, String[].class);
        if (prefixs == null) {
            return false;
        }
        for (String prefix : prefixs) {
            if (!StringMatchers.matchAny(prefix, serviceClass.getName()) && !AntPathMatcher.POINT_PATH_MATCHER.match(prefix, serviceClass.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Value wrap(String key, Object value) {
        if (value instanceof Value) {
            return (Value)value;
        }
        AnyFormatValue v = new AnyFormatValue(value);
        return v;
    }

    private class AnyFormatValue
    extends AnyValue {
        public AnyFormatValue(Object value) {
            super(value, null, DefaultEnvironment.this.getConversionService());
        }

        @Override
        public String getAsString() {
            return DefaultEnvironment.this.replacePlaceholders(super.getAsString());
        }
    }
}

