/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.env;

import io.basc.framework.env.ConfigurableEnvironmentResourceLoader;
import io.basc.framework.env.DefaultProfilesResolver;
import io.basc.framework.env.Environment;
import io.basc.framework.env.ProfilesResolver;
import io.basc.framework.event.Observable;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.io.FileSystemResource;
import io.basc.framework.io.FileSystemResourceLoader;
import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourceUtils;
import io.basc.framework.io.Resources;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassLoaderProvider;
import io.basc.framework.util.ConcurrentReferenceHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

class DefaultEnvironmentResourceLoader
extends FileSystemResourceLoader
implements ConfigurableEnvironmentResourceLoader {
    private static final String AUTO_SELECT_RESOURCE = "basc.env.auto.select.resource";
    private static Logger logger = LoggerFactory.getLogger(DefaultEnvironmentResourceLoader.class);
    private final ConcurrentReferenceHashMap<String, Resource> cacheMap = new ConcurrentReferenceHashMap(256);
    private ProfilesResolver profilesResolver = DefaultProfilesResolver.INSTANCE;
    private final Environment environment;
    private volatile Observable<Boolean> autoSelect;

    public DefaultEnvironmentResourceLoader(Environment environment) {
        this.environment = environment;
    }

    @Override
    public ClassLoaderProvider getClassLoaderProvider() {
        ClassLoaderProvider classLoaderProvider = super.getClassLoaderProvider();
        if (classLoaderProvider == null) {
            return this.environment;
        }
        return classLoaderProvider;
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        if (serviceLoaderFactory.isInstance(ProfilesResolver.class)) {
            this.setProfilesResolver(serviceLoaderFactory.getInstance(ProfilesResolver.class));
        }
        super.configure(serviceLoaderFactory);
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ProfilesResolver getProfilesResolver() {
        return this.profilesResolver;
    }

    public void setProfilesResolver(ProfilesResolver profilesResolver) {
        Assert.requiredArgument(profilesResolver != null, "profilesResolver");
        logger.info("Set profiles resolver [{}]", profilesResolver);
        this.profilesResolver = profilesResolver;
    }

    @Override
    protected boolean ignoreClassPathResource(FileSystemResource resource) {
        return super.ignoreClassPathResource(resource) || resource.getPath().startsWith(this.environment.getWorkPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAutoSelectResource() {
        if (this.autoSelect == null) {
            DefaultEnvironmentResourceLoader defaultEnvironmentResourceLoader = this;
            synchronized (defaultEnvironmentResourceLoader) {
                if (this.autoSelect == null) {
                    this.autoSelect = this.environment.getProperties().getObservable(AUTO_SELECT_RESOURCE).map(e -> e.getAsBoolean());
                }
            }
        }
        return (Boolean)this.autoSelect.get();
    }

    @Override
    public Resource getResource(String location) {
        if (this.isAutoSelectResource()) {
            Resource[] resources = this.getResources(location);
            if (resources == null) {
                return ResourceUtils.NONEXISTENT_RESOURCE;
            }
            Resources rs = new Resources();
            rs.registers(Arrays.asList(resources));
            return rs;
        }
        return super.getResource(location);
    }

    @Override
    public Resource[] getResources(String locationPattern) {
        Collection<String> names = this.profilesResolver.resolve(this.environment.getProperties(), this.environment.replacePlaceholders(locationPattern));
        ArrayList<Resource> resources = new ArrayList<Resource>(names.size());
        for (String name : names) {
            Resource res = this.getResourceByCache(name);
            if (res == null) continue;
            resources.add(res);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Get resources [{}] results {}", resources);
        }
        return resources.isEmpty() ? new Resource[]{} : resources.toArray(new Resource[0]);
    }

    private Resource getResourceByCache(String location) {
        Resource resource = this.cacheMap.get(location);
        if (resource == null) {
            resource = super.getResource(location);
            if (resource == null) {
                return null;
            }
            if (resource.exists() && !resource.getName().endsWith(".class")) {
                Resource cache = this.cacheMap.putIfAbsent(location, resource);
                if (cache != null) {
                    resource = cache;
                } else {
                    this.cacheMap.purgeUnreferencedEntries();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Find resource {} result {}", location, resource);
                    }
                }
                return resource;
            }
            return ResourceUtils.NONEXISTENT_RESOURCE;
        }
        return resource;
    }
}

