/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.env;

import io.basc.framework.env.DefaultEnvironment;
import io.basc.framework.event.Observable;
import io.basc.framework.factory.FactoryException;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Optional;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.XUtils;
import io.basc.framework.value.support.SystemPropertyFactory;
import java.util.Properties;

public final class Sys
extends DefaultEnvironment {
    private static Sys env = new Sys();
    private static Logger logger = LoggerFactory.getLogger(Sys.class);
    public static final String WEB_ROOT_PROPERTY = "web.root";

    public static Sys getEnv() {
        return env;
    }

    private Sys() {
    }

    @Override
    public void init() throws FactoryException {
        try {
            String path = this.getWorkPath();
            if (path == null && (path = XUtils.getWebAppDirectory(this.getResourceLoader().getClassLoader())) != null) {
                this.setWorkPath(path);
                logger.info("default io.basc.framework.work.path in " + path);
            }
            if (StringUtils.isEmpty(this.getProperties().getAsString(WEB_ROOT_PROPERTY))) {
                this.getProperties().put(WEB_ROOT_PROPERTY, (Object)path);
            }
        }
        catch (Throwable e) {
            logger.error(e, "Initialization working path exception");
        }
        super.init();
        this.getProperties().getPropertyFactories().getFactories().addService(SystemPropertyFactory.INSTANCE);
        try {
            this.source("system.properties");
            String resourceName = Optional.ofNullable(this.getProperties().getAsString("io.basc.framework.properties")).orElse("/private.properties");
            this.source(resourceName);
        }
        catch (Throwable e) {
            logger.error(e, "Initialization profile exception");
        }
    }

    static {
        try {
            env.init();
        }
        finally {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> env.destroy()));
        }
        try {
            String resourceName = Optional.ofNullable(env.getProperties().getAsString("io.basc.framework.logger.level.properties")).orElse("/logger-level.properties");
            Observable<Properties> observable = env.getProperties(resourceName);
            LoggerFactory.getSource().getLevelManager().registerProperties(observable);
        }
        catch (Throwable e) {
            logger.error(e, "Initialization log level configuration exception");
        }
    }
}

