/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event;

import io.basc.framework.event.AbstractObservable;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.Observable;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.util.Registration;
import java.util.function.Function;

class ConvertObservable<S, T>
extends AbstractObservable<T> {
    private final Observable<S> source;
    private final Function<? super S, ? extends T> mapper;

    ConvertObservable(Observable<S> source, Function<? super S, ? extends T> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public Registration registerListener(EventListener<ObservableChangeEvent<T>> eventListener) {
        return this.source.registerListener((T e) -> eventListener.onEvent(new ObservableChangeEvent<T>(e, this.mapper)));
    }

    @Override
    protected T getValue() {
        Object value = this.source.orElse(null);
        return this.mapper.apply(value);
    }
}

