/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event;

import io.basc.framework.codec.Codec;
import io.basc.framework.event.BroadcastDelayableEventDispatcher;
import io.basc.framework.event.DelayableEventDispatcher;
import io.basc.framework.event.EventDispatcher;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.EventPushException;
import io.basc.framework.event.EventRegistrationException;
import io.basc.framework.event.EventRegistry;
import io.basc.framework.event.UnicastDelayableEventDispatcher;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Registration;
import java.util.concurrent.TimeUnit;

public class ConvertibleEventDispatcher<S, T>
implements UnicastDelayableEventDispatcher<T>,
BroadcastDelayableEventDispatcher<T> {
    private final EventRegistry<S> source;
    private final Codec<T, S> codec;

    public ConvertibleEventDispatcher(EventRegistry<S> source, Codec<T, S> codec) {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(codec != null, "codec");
        this.source = source;
        this.codec = codec;
    }

    @Override
    public void publishEvent(T event) throws EventPushException {
        if (this.source instanceof EventDispatcher) {
            ((EventDispatcher)this.source).publishEvent(this.codec.encode(event));
            return;
        }
        throw new UnsupportedException("Not a EventDispatcher");
    }

    @Override
    public Registration registerListener(EventListener<T> eventListener) throws EventRegistrationException {
        return this.source.registerListener(e -> eventListener.onEvent(this.codec.decode(e)));
    }

    @Override
    public void publishEvent(T event, long delay, TimeUnit delayTimeUnit) throws EventPushException {
        if (this.source instanceof DelayableEventDispatcher) {
            ((DelayableEventDispatcher)this.source).publishEvent(this.codec.encode(event), delay, delayTimeUnit);
            return;
        }
        throw new UnsupportedException("Not a DelayableEventDispatcher");
    }
}

