/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.Encoder;
import io.basc.framework.event.BroadcastDelayableNamedEventDispatcher;
import io.basc.framework.event.DelayableNamedEventDispatcher;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.EventPushException;
import io.basc.framework.event.EventRegistrationException;
import io.basc.framework.event.NamedEventDispatcher;
import io.basc.framework.event.NamedEventRegistry;
import io.basc.framework.event.UnicastDelayableNamedEventDispatcher;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Registration;
import java.util.concurrent.TimeUnit;

public class ConvertibleNamedEventDispatcher<SK, K, ST, T>
implements UnicastDelayableNamedEventDispatcher<K, T>,
BroadcastDelayableNamedEventDispatcher<K, T> {
    private final NamedEventRegistry<SK, ST> source;
    private final Encoder<K, SK> nameEncoder;
    private final Codec<T, ST> eventCodec;

    public ConvertibleNamedEventDispatcher(NamedEventRegistry<SK, ST> source, Encoder<K, SK> nameEncoder, Codec<T, ST> eventCodec) {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(nameEncoder != null, "nameEncoder");
        Assert.requiredArgument(eventCodec != null, "eventCodec");
        this.source = source;
        this.nameEncoder = nameEncoder;
        this.eventCodec = eventCodec;
    }

    @Override
    public void publishEvent(K name, T event) throws EventPushException {
        if (this.source instanceof NamedEventDispatcher) {
            ((NamedEventDispatcher)this.source).publishEvent(this.nameEncoder.encode(name), this.eventCodec.encode(event));
            return;
        }
        throw new UnsupportedException("Not a NamedEventDispatcher");
    }

    @Override
    public Registration registerListener(K name, EventListener<T> eventListener) throws EventRegistrationException {
        return this.source.registerListener(this.nameEncoder.encode(name), e -> eventListener.onEvent(this.eventCodec.decode(e)));
    }

    @Override
    public void publishEvent(K name, T event, long delay, TimeUnit delayTimeUnit) throws EventPushException {
        if (this.source instanceof DelayableNamedEventDispatcher) {
            ((DelayableNamedEventDispatcher)this.source).publishEvent(this.nameEncoder.encode(name), this.eventCodec.encode(event), delay, delayTimeUnit);
            return;
        }
        throw new UnsupportedException("Not a DelayableNamedEventDispatcher");
    }
}

