/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event;

import io.basc.framework.event.AbstractObservable;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.Observable;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.util.Registration;
import java.util.function.Predicate;

class FilterObservable<T>
extends AbstractObservable<T> {
    private final Observable<T> source;
    private final Predicate<? super T> predicate;

    FilterObservable(Observable<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public Registration registerListener(EventListener<ObservableChangeEvent<T>> eventListener) {
        return this.source.registerListener(eventListener);
    }

    @Override
    protected T getValue() {
        T value = this.source.orElse(null);
        if (value == null) {
            return null;
        }
        return this.predicate.test(value) ? value : null;
    }
}

