/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event;

import io.basc.framework.event.ChangeEvent;
import io.basc.framework.event.ChangeType;
import java.util.function.Function;

public class ObservableChangeEvent<T>
extends ChangeEvent<T> {
    private static final long serialVersionUID = 1L;
    private final T oldSource;

    public ObservableChangeEvent(ChangeType changeType, T oldSource, T source) {
        super(changeType, source);
        this.oldSource = oldSource;
    }

    public ObservableChangeEvent(ChangeEvent<?> sourceEvent, T oldSource, T source) {
        super(sourceEvent, source);
        this.oldSource = oldSource;
    }

    public <S> ObservableChangeEvent(ObservableChangeEvent<S> source, Function<? super S, ? extends T> mapper) {
        super(source, source.getSource() == null ? null : (Object)mapper.apply((S)source.getSource()));
        this.oldSource = source.getOldSource() == null ? null : mapper.apply((S)source.getOldSource());
    }

    public T getOldSource() {
        return this.oldSource;
    }

    @Override
    public String toString() {
        return "ObservableChangeEvent(super=" + super.toString() + ", oldSource=" + this.getOldSource() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObservableChangeEvent)) {
            return false;
        }
        ObservableChangeEvent other = (ObservableChangeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        T this$oldSource = this.getOldSource();
        T other$oldSource = other.getOldSource();
        return !(this$oldSource == null ? other$oldSource != null : !this$oldSource.equals(other$oldSource));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ObservableChangeEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        T $oldSource = this.getOldSource();
        result = result * 59 + ($oldSource == null ? 43 : $oldSource.hashCode());
        return result;
    }
}

