/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event;

import io.basc.framework.event.AbstractObservable;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.Observable;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.Registration;
import java.util.ArrayList;
import java.util.List;

public class Observables<T>
extends AbstractObservable<List<T>> {
    private final List<? extends Observable<T>> sources;

    public Observables(List<? extends Observable<T>> sources) {
        Assert.requiredArgument(!CollectionUtils.isEmpty(sources), "sources");
        this.sources = sources;
    }

    @Override
    public Registration registerListener(EventListener<ObservableChangeEvent<List<T>>> eventListener) {
        Registration registration = Registration.EMPTY;
        int index = 0;
        for (Observable<T> source : this.sources) {
            registration = registration.and(source.registerListener(new IndexEventListener(index, eventListener)));
        }
        return registration;
    }

    @Override
    public List<T> getValue() {
        ArrayList list = new ArrayList(this.sources.size());
        this.sources.forEach(e -> e.ifPresent(list::add));
        return list;
    }

    private class IndexEventListener
    implements EventListener<ObservableChangeEvent<T>> {
        private final int index;
        private final EventListener<ObservableChangeEvent<List<T>>> targetEventListener;

        IndexEventListener(int index, EventListener<ObservableChangeEvent<List<T>>> targetEventListener) {
            this.index = index;
            this.targetEventListener = targetEventListener;
        }

        @Override
        public void onEvent(ObservableChangeEvent<T> event) {
            ArrayList newValue = new ArrayList(Observables.this.sources.size());
            Observables.this.sources.forEach(e -> newValue.add(e.orElse(null)));
            ArrayList oldValue = new ArrayList(newValue);
            oldValue.set(this.index, event.getOldSource());
            this.targetEventListener.onEvent(new ObservableChangeEvent(event, oldValue, newValue));
        }
    }
}

