/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event.support;

import io.basc.framework.event.AbstractObservable;
import io.basc.framework.event.ChangeEvent;
import io.basc.framework.event.ChangeType;
import io.basc.framework.event.EventDispatcher;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.NamedEventRegistry;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.event.support.StandardBroadcastEventDispatcher;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CollectionFactory;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Registration;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ObservableMap<K, V>
extends AbstractObservable<Map<K, V>>
implements EventDispatcher<ObservableChangeEvent<Map<K, V>>>,
NamedEventRegistry<K, ChangeEvent<K>> {
    private final Map<K, V> targetMap;
    private final EventDispatcher<ObservableChangeEvent<Map<K, V>>> eventDispatcher;

    public ObservableMap() {
        this(new ConcurrentHashMap());
    }

    public ObservableMap(Map<K, V> targetMap) {
        this(targetMap, new StandardBroadcastEventDispatcher<ObservableChangeEvent<Map<K, V>>>());
    }

    public ObservableMap(Map<K, V> targetMap, EventDispatcher<ObservableChangeEvent<Map<K, V>>> eventDispatcher) {
        Assert.isTrue(!CollectionUtils.isUnmodifiable(targetMap), "TargetMap Cannot be an Unmodifiable");
        Assert.requiredArgument(eventDispatcher != null, "eventDispatcher");
        this.targetMap = targetMap;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public Registration registerListener(EventListener<ObservableChangeEvent<Map<K, V>>> eventListener) {
        return this.eventDispatcher.registerListener(eventListener);
    }

    @Override
    public void publishEvent(ObservableChangeEvent<Map<K, V>> event) {
        this.eventDispatcher.publishEvent(event);
    }

    public Map<K, V> getTargetMap() {
        return Collections.unmodifiableMap(this.targetMap);
    }

    @Override
    protected Map<K, V> getValue() {
        return this.targetMap.isEmpty() ? null : this.targetMap;
    }

    public V put(K key, V value) {
        V oldValue = this.targetMap.put(key, value);
        if (oldValue != value) {
            this.publishEvent(new ObservableChangeEvent<Map<K, V>>(oldValue == null ? ChangeType.CREATE : ChangeType.UPDATE, Collections.singletonMap(key, oldValue), Collections.singletonMap(key, value)));
        }
        return oldValue;
    }

    public V putIfAbsent(K key, V value) {
        V oldValue = this.targetMap.putIfAbsent(key, value);
        if (oldValue == null && oldValue != value) {
            this.publishEvent(new ObservableChangeEvent<Map<K, V>>(ChangeType.CREATE, null, Collections.singletonMap(key, value)));
        }
        return oldValue;
    }

    public V putIfPresent(K key, V value) {
        Object oldValue = this.targetMap.computeIfPresent(key, (k, v) -> value);
        if (oldValue != null && oldValue != value) {
            this.publishEvent(new ObservableChangeEvent<Map<K, V>>(ChangeType.UPDATE, Collections.singletonMap(key, oldValue), Collections.singletonMap(key, value)));
        }
        return (V)oldValue;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        Map<? extends K, ? extends V> all = CollectionFactory.createApproximateMap(map, 16);
        all.putAll(map);
        this.targetMap.putAll(all);
        this.publishEvent(new ObservableChangeEvent(ChangeType.UPDATE, null, all));
    }

    public void clear() {
        Map<K, V> all = CollectionFactory.createApproximateMap(this.targetMap, 16);
        all.putAll(this.targetMap);
        Iterator iterator = all.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.targetMap.remove(entry.getKey(), entry.getValue())) continue;
            iterator.remove();
        }
        this.publishEvent(new ObservableChangeEvent<Object>(ChangeType.DELETE, all, null));
    }

    public int size() {
        return this.targetMap.size();
    }

    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    public V get(K key) {
        return this.targetMap.get(key);
    }

    public V remove(K key) {
        V value = this.targetMap.remove(key);
        if (value != null) {
            this.publishEvent(new ObservableChangeEvent<Object>(ChangeType.DELETE, Collections.singletonMap(key, value), null));
        }
        return value;
    }

    public Set<K> keySet() {
        return this.getTargetMap().keySet();
    }

    public Collection<V> values() {
        return this.getTargetMap().values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.getTargetMap().entrySet();
    }

    @Override
    public Registration registerListener(K name, EventListener<ChangeEvent<K>> eventListener) {
        return this.registerListener((ObservableChangeEvent<Map<K, V>> event) -> {
            Map changeMap = (Map)event.getSource();
            if (CollectionUtils.isEmpty(changeMap)) {
                return;
            }
            ConsumeProcessor.consumeAll(changeMap.entrySet().iterator(), e -> eventListener.onEvent(new ChangeEvent(event.getChangeType(), e.getKey())));
        });
    }
}

