/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event.support;

import io.basc.framework.event.DelayableEventDispatcher;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.support.StandardEventDispatcher;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Selector;
import io.basc.framework.util.concurrent.DelayableExecutor;
import java.util.concurrent.TimeUnit;

public class StandardDelayableEventDispatcher<T>
extends StandardEventDispatcher<T>
implements DelayableEventDispatcher<T> {
    private final DelayableExecutor delayableExecutor;

    public StandardDelayableEventDispatcher(@Nullable Selector<EventListener<T>> selector, DelayableExecutor delayableExecutor) {
        super(selector, null);
        Assert.requiredArgument(delayableExecutor != null, "delayableExecutor");
        this.delayableExecutor = delayableExecutor;
    }

    @Override
    public void publishEvent(T event) {
        this.publishEvent(event, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void publishEvent(T event, long delay, TimeUnit delayTimeUnit) {
        Assert.requiredArgument(delay >= 0L, "delay");
        this.delayableExecutor.schedule(() -> super.publishEvent(event), delay, delayTimeUnit);
    }
}

