/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event.support;

import io.basc.framework.event.EventDispatcher;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.NamedEventDispatcher;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Matcher;
import io.basc.framework.util.Registration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class StandardNamedEventDispatcher<K, T>
implements NamedEventDispatcher<K, T> {
    private volatile Map<K, EventDispatcher<T>> dispatcherMap;
    @Nullable
    private final Matcher<K> matcher;
    private final Function<? super K, ? extends EventDispatcher<T>> creator;
    private final Executor executor;

    public StandardNamedEventDispatcher(Function<? super K, ? extends EventDispatcher<T>> creator, @Nullable Matcher<K> matcher, @Nullable Executor executor) {
        Assert.requiredArgument(creator != null, "creator");
        this.creator = creator;
        this.matcher = matcher;
        this.executor = executor;
    }

    public Matcher<K> getMatcher() {
        return this.matcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registration registerListener(K name, EventListener<T> eventListener) {
        StandardNamedEventDispatcher standardNamedEventDispatcher;
        if (this.dispatcherMap == null) {
            standardNamedEventDispatcher = this;
            synchronized (standardNamedEventDispatcher) {
                if (this.dispatcherMap == null) {
                    this.dispatcherMap = this.matcher == null ? new HashMap(8) : new TreeMap(this.matcher);
                }
            }
        }
        standardNamedEventDispatcher = this;
        synchronized (standardNamedEventDispatcher) {
            EventDispatcher<T> eventDispatcher = this.dispatcherMap.get(name);
            if (eventDispatcher == null) {
                eventDispatcher = this.creator.apply(name);
                this.dispatcherMap.put(name, eventDispatcher);
            }
            return eventDispatcher.registerListener(eventListener);
        }
    }

    @Override
    public void publishEvent(K name, T event) {
        if (this.executor == null) {
            this.syncPublishEvent(name, event);
        } else {
            this.executor.execute(() -> this.syncPublishEvent(name, event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <X extends Throwable> void consume(K name, ConsumeProcessor<EventDispatcher<T>, ? extends X> consumer) throws X {
        if (this.dispatcherMap != null) {
            StandardNamedEventDispatcher standardNamedEventDispatcher = this;
            synchronized (standardNamedEventDispatcher) {
                if (this.dispatcherMap != null) {
                    if (this.matcher == null) {
                        EventDispatcher<T> dispatcher = this.dispatcherMap.get(name);
                        if (dispatcher == null) {
                            return;
                        }
                        consumer.process(dispatcher);
                    } else {
                        for (Map.Entry<K, EventDispatcher<T>> entry : this.dispatcherMap.entrySet()) {
                            if (!this.matcher.match(entry.getKey(), name) && !this.matcher.match(name, entry.getKey())) continue;
                            consumer.process(entry.getValue());
                        }
                    }
                }
            }
        }
    }

    public void syncPublishEvent(K name, T event) {
        this.consume(name, e -> e.publishEvent(event));
    }
}

