/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event.support;

import io.basc.framework.event.AbstractObservable;
import io.basc.framework.event.ChangeEvent;
import io.basc.framework.event.ChangeType;
import io.basc.framework.event.EventDispatcher;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.Observable;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.event.support.StandardBroadcastEventDispatcher;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.Registration;
import io.basc.framework.util.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class StandardObservable<T>
extends AbstractObservable<T>
implements EventDispatcher<ObservableChangeEvent<T>> {
    private final AtomicReference<T> valueReference = new AtomicReference();
    private final EventDispatcher<ObservableChangeEvent<T>> eventDispatcher;
    private volatile LinkedHashSet<Observable<? extends T>> sources;
    private Selector<T> selector;

    public StandardObservable() {
        this(new StandardBroadcastEventDispatcher<ObservableChangeEvent<T>>());
    }

    public StandardObservable(EventDispatcher<ObservableChangeEvent<T>> eventDispatcher) {
        Assert.requiredArgument(eventDispatcher != null, "eventDispatcher");
        this.eventDispatcher = eventDispatcher;
    }

    public void setSelector(Selector<T> selector) {
        this.selector = selector;
        this.touch(null);
    }

    public final Selector<T> getSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registration registers(Iterator<? extends Observable<? extends T>> observables) {
        Assert.requiredArgument(observables != null, "observables");
        StandardObservable standardObservable = this;
        synchronized (standardObservable) {
            if (this.sources == null) {
                this.sources = new LinkedHashSet(8);
            }
            Registration registration = null;
            while (observables.hasNext()) {
                Observable<ObservableChangeEvent> observable = observables.next();
                if (observable == null || observable == this || !this.sources.add(observable)) continue;
                if (registration == null) {
                    registration = Registration.EMPTY;
                }
                registration = registration.and(observable.registerListener((T e) -> this.touch(new ObservableChangeEvent((ChangeEvent<?>)e, e.getOldSource(), e.getSource()))));
                registration = registration.and(() -> {
                    if (this.sources.remove(observable)) {
                        this.touch(null);
                    }
                });
            }
            if (registration != null) {
                this.touch(null);
            }
            return registration == null ? Registration.EMPTY : registration;
        }
    }

    public Registration registers(Iterable<? extends Observable<? extends T>> observables) {
        Assert.requiredArgument(observables != null, "observables");
        return this.registers(observables.iterator());
    }

    public Registration register(Observable<? extends T> observable) {
        Assert.requiredArgument(observable != null, "observable");
        return this.registers(Arrays.asList(observable));
    }

    private void touch(ObservableChangeEvent<T> event) {
        if (this.getSources().size() > 1) {
            this.set(this.select());
            return;
        }
        T value = this.valueReference.get();
        if (value == null) {
            if (event != null) {
                this.publishEvent(event);
            }
        } else if (event == null) {
            this.publishEvent(new ObservableChangeEvent<T>(ChangeType.DELETE, value, this.select()));
        } else {
            this.publishEvent(event);
        }
    }

    public final Set<Observable<? extends T>> getSources() {
        return this.sources == null ? Collections.emptySet() : Collections.unmodifiableSet(this.sources);
    }

    protected T select() {
        if (this.selector == null) {
            for (Observable observable : this.sources) {
                T t;
                if (observable == null || observable == this || (t = observable.orElse(null)) == null) continue;
                return t;
            }
            return null;
        }
        ArrayList values = new ArrayList(this.sources.size());
        for (Observable observable : this.sources) {
            if (observable == null || observable == this) continue;
            observable.ifPresent(values::add);
        }
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return (T)values.get(0);
        }
        return this.selector.apply(values);
    }

    @Override
    public Registration registerListener(EventListener<ObservableChangeEvent<T>> eventListener) {
        return this.eventDispatcher.registerListener(eventListener);
    }

    @Override
    public void publishEvent(ObservableChangeEvent<T> event) {
        this.eventDispatcher.publishEvent(event);
    }

    public AtomicReference<T> getValueReference() {
        return this.valueReference;
    }

    @Override
    protected T getValue() {
        T value = this.valueReference.get();
        if (value == null && this.getSources().size() == 1) {
            return ((Observable)Cursor.of(this.getSources()).first()).orElse(null);
        }
        return value;
    }

    private void publishEvent(T oldValue, T newValue) {
        if (oldValue == newValue) {
            return;
        }
        if (oldValue == null) {
            if (newValue == null) {
                return;
            }
            this.publishEvent(new ObservableChangeEvent<T>(ChangeType.CREATE, oldValue, newValue));
        } else if (newValue == null) {
            this.publishEvent(new ObservableChangeEvent<T>(ChangeType.DELETE, oldValue, newValue));
        } else {
            this.publishEvent(new ObservableChangeEvent<T>(ChangeType.UPDATE, oldValue, newValue));
        }
    }

    public T set(T value) {
        T old = this.valueReference.getAndSet(value);
        this.publishEvent(old, value);
        return old;
    }

    public boolean set(T oldValue, T newValue) {
        if (oldValue == newValue) {
            return false;
        }
        if (this.valueReference.compareAndSet(oldValue, newValue)) {
            this.publishEvent(oldValue, newValue);
            return true;
        }
        return false;
    }
}

