/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.event.support;

import io.basc.framework.event.BroadcastEventDispatcher;
import io.basc.framework.event.ChangeEvent;
import io.basc.framework.event.ChangeType;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.NamedEventRegistry;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.event.support.ObservableMap;
import io.basc.framework.event.support.StandardBroadcastEventDispatcher;
import io.basc.framework.event.support.StandardObservable;
import io.basc.framework.util.CollectionFactory;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.MapCombiner;
import io.basc.framework.util.Registration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StandardObservableMap<K, V>
extends StandardObservable<Map<K, V>>
implements NamedEventRegistry<K, ChangeEvent<K>> {
    private final ObservableMap<K, V> sourceMap;
    private final MapCombiner<K, V> select = new MapCombiner();

    public StandardObservableMap() {
        this(new ConcurrentHashMap());
    }

    public StandardObservableMap(Map<K, V> sourceMap) {
        this(new StandardBroadcastEventDispatcher<ObservableChangeEvent<Map<K, V>>>(), sourceMap);
    }

    public StandardObservableMap(BroadcastEventDispatcher<ObservableChangeEvent<Map<K, V>>> eventDispatcher, Map<K, V> sourceMap) {
        super(eventDispatcher);
        this.setSelector(this.select);
        this.sourceMap = new ObservableMap<K, V>(sourceMap, eventDispatcher){

            @Override
            public void publishEvent(ObservableChangeEvent<Map<K, V>> event) {
                if (!StandardObservableMap.this.getSources().isEmpty()) {
                    StandardObservableMap.this.getValueReference().set(StandardObservableMap.this.select());
                }
                super.publishEvent(event);
            }
        };
    }

    public ObservableMap<K, V> getSourceMap() {
        return this.sourceMap;
    }

    @Override
    protected Map<K, V> select() {
        Map map = (Map)super.select();
        if (CollectionUtils.isEmpty(map)) {
            return this.sourceMap.getTargetMap();
        }
        Map approximateMap = CollectionFactory.createApproximateMap(this.sourceMap.getTargetMap(), 16);
        Object applyMap = this.select.apply((List)Arrays.asList(map, this.sourceMap.getTargetMap()));
        approximateMap.putAll(applyMap);
        return map;
    }

    @Override
    public Registration registerListener(K name, EventListener<ChangeEvent<K>> eventListener) {
        return this.registerListener((ObservableChangeEvent<T> e) -> {
            Map oldMap = (Map)e.getOldSource();
            Map newMap = (Map)e.getSource();
            if (CollectionUtils.isEmpty(oldMap)) {
                if (CollectionUtils.isEmpty(newMap)) {
                    return;
                }
                ConsumeProcessor.consumeAll(newMap.keySet(), key -> eventListener.onEvent(new ChangeEvent<Object>(e.getCreateTime(), ChangeType.CREATE, key)));
            } else if (CollectionUtils.isEmpty(newMap)) {
                ConsumeProcessor.consumeAll(oldMap.keySet(), key -> eventListener.onEvent(new ChangeEvent<Object>(e.getCreateTime(), ChangeType.DELETE, key)));
            } else {
                List keys = Stream.concat(oldMap.keySet().stream(), newMap.keySet().stream()).filter((? super T key) -> !Objects.equals(oldMap.get(key), newMap.get(key))).collect(Collectors.toList());
                ConsumeProcessor.consumeAll(keys, key -> eventListener.onEvent(new ChangeEvent<Object>(e.getCreateTime(), ChangeType.UPDATE, key)));
            }
        });
    }

    @Override
    protected Map<K, V> getValue() {
        Map<K, V> map = (Map<K, V>)super.getValue();
        if (CollectionUtils.isEmpty(map)) {
            map = this.sourceMap.getTargetMap();
        }
        return CollectionUtils.isEmpty(map) ? null : map;
    }

    public V get(K key) {
        return this.orElse(Collections.emptyMap()).get(key);
    }

    public int size() {
        return this.orElse(Collections.emptyMap()).size();
    }

    public boolean containsKey(Object key) {
        return this.orElse(Collections.emptyMap()).containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.orElse(Collections.emptyMap()).containsValue(value);
    }

    public Set<K> keySet() {
        return this.orElse(Collections.emptyMap()).keySet();
    }

    public Collection<V> values() {
        return this.orElse(Collections.emptyMap()).values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.orElse(Collections.emptyMap()).entrySet();
    }
}

