/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory;

import io.basc.framework.aop.Aop;
import io.basc.framework.core.ResolvableType;
import io.basc.framework.factory.BeanDefinitionFactory;
import io.basc.framework.factory.BeanLifecycleManager;
import io.basc.framework.factory.BeanResolver;
import io.basc.framework.factory.FactoryException;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.factory.SingletonFactory;
import io.basc.framework.util.ParentDiscover;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Collectors;

public interface BeanFactory
extends ServiceLoaderFactory,
BeanDefinitionFactory,
SingletonFactory,
BeanLifecycleManager,
ParentDiscover<BeanFactory> {
    public Aop getAop();

    default public Map<String, Object> getBeans(ResolvableType type) {
        return this.matchType(type).filter(e -> this.isInstance(e.getId())).collect(Collectors.toMap(e -> e.getId(), e -> this.getInstance(e.getId())));
    }

    default public Map<String, Object> getBeans(Type type) {
        return this.getBeans(ResolvableType.forType(type));
    }

    default public <T> Map<String, T> getBeans(Class<? extends T> type) {
        return this.getBeans(ResolvableType.forClass(type));
    }

    public boolean isSingleton(Class<?> var1);

    public boolean isSingleton(String var1);

    public BeanResolver getBeanResolver();

    public Object getInstance(String var1, Object ... var2) throws FactoryException;

    public boolean isInstance(Class<?> var1, Object ... var2);

    public boolean isInstance(String var1, Class<?> ... var2);

    public boolean isInstance(String var1, Object ... var2);

    public <T> T getInstance(Class<? extends T> var1, Class<?>[] var2, Object ... var3) throws FactoryException;

    public <T> T getInstance(Class<? extends T> var1, Object ... var2) throws FactoryException;

    public Object getInstance(String var1, Class<?>[] var2, Object ... var3) throws FactoryException;

    public boolean isInstance(Class<?> var1, Class<?> ... var2);
}

