/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory;

import io.basc.framework.core.ParameterizedTypeReference;
import io.basc.framework.core.ResolvableType;
import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.ServiceLoader;
import io.basc.framework.util.Services;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

public class ConfigurableServices<T>
extends Services<T>
implements Configurable,
ServiceLoader<T> {
    private static Logger LOGGER = LoggerFactory.getLogger(ConfigurableServices.class);
    private volatile List<? extends T> defaultServices;
    private Logger logger = LOGGER;
    private Class<T> serviceClass;
    private volatile ServiceLoaderFactory serviceLoaderFactory;

    public ConfigurableServices() {
        this(null, null);
    }

    public ConfigurableServices(Class<T> serviceClass) {
        this(serviceClass, null);
    }

    public ConfigurableServices(@Nullable Class<T> serviceClass, @Nullable Supplier<Collection<T>> supplier) {
        super(supplier);
        this.serviceClass = serviceClass;
        if (this.serviceClass == null) {
            try {
                ResolvableType type = ResolvableType.forType(new ParameterizedTypeReference<T>(){});
                if (!type.hasGenerics()) {
                    this.serviceClass = type.getRawClass() == Object.class ? null : type.getRawClass();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ConfigurableServices(Supplier<Collection<T>> supplier) {
        this(null, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Class<? extends T> serviceClass, ServiceLoaderFactory serviceLoaderFactory) {
        if (serviceLoaderFactory == null || serviceClass == null) {
            return;
        }
        ConfigurableServices configurableServices = this;
        synchronized (configurableServices) {
            ArrayList<Object> newServices = new ArrayList<Object>();
            newServices.addAll(this.getTargetServices());
            if (this.defaultServices != null) {
                newServices.removeAll(this.defaultServices);
            }
            this.defaultServices = serviceLoaderFactory.getServiceLoader(serviceClass).toList();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Configure [{}] services {}", serviceClass, this.defaultServices);
            }
            if (this.defaultServices != null) {
                newServices.addAll(this.defaultServices);
            }
            this.clear();
            this.addServices(newServices);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConfigured() {
        ConfigurableServices configurableServices = this;
        synchronized (configurableServices) {
            return this.serviceLoaderFactory != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        ConfigurableServices configurableServices = this;
        synchronized (configurableServices) {
            this.serviceLoaderFactory = serviceLoaderFactory;
            this.configure(this.serviceClass, serviceLoaderFactory);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public Class<T> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<T> serviceClass) {
        this.serviceClass = serviceClass;
    }

    @Override
    public Cursor<T> iterator() {
        return Cursor.of(super.iterator());
    }

    @Override
    public void reload() {
        if (this.serviceLoaderFactory != null) {
            this.configure(this.serviceLoaderFactory);
        }
    }

    public void setLogger(Logger logger) {
        Assert.requiredArgument(logger != null, "logger");
        this.logger = logger;
    }

    @Override
    public String toString() {
        if (this.serviceClass == null) {
            return super.toString();
        }
        return "[" + this.serviceClass.getName() + "] services " + super.toString();
    }
}

