/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.factory.ParametersFactory;
import io.basc.framework.lang.ParameterException;
import io.basc.framework.logger.Levels;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.mapper.ParameterDescriptor;
import io.basc.framework.mapper.ParameterDescriptors;
import java.util.logging.Level;

public abstract class AbstractParametersFactory
implements ParametersFactory {
    private static Logger logger = LoggerFactory.getLogger(AbstractParametersFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAccept(ParameterDescriptors parameterDescriptors) {
        int index = 0;
        for (ParameterDescriptor parameterDescriptor : parameterDescriptors) {
            try {
                Level level;
                boolean auto = this.isAccept(parameterDescriptors, parameterDescriptor, index);
                Level level2 = level = auto ? Levels.TRACE.getValue() : Levels.DEBUG.getValue();
                if (logger.isLoggable(level)) {
                    logger.log(level, "{} parameter index {} matching: {}", parameterDescriptors.getSource(), index, auto ? "success" : "fail");
                }
                if (auto) continue;
                boolean bl = false;
                return bl;
            }
            catch (StackOverflowError e) {
                logger.error(e, "There are circular references clazz [{}] parameterName [{}] in [{}]", parameterDescriptors.getDeclaringClass(), parameterDescriptor.getName(), parameterDescriptors.getSource());
                boolean bl = false;
                return bl;
            }
            finally {
                ++index;
            }
        }
        return true;
    }

    protected abstract boolean isAccept(ParameterDescriptors var1, ParameterDescriptor var2, int var3);

    @Override
    public Object[] getParameters(ParameterDescriptors parameterDescriptors) {
        Object[] args = new Object[parameterDescriptors.size()];
        int index = 0;
        for (ParameterDescriptor parameterDescriptor : parameterDescriptors) {
            try {
                args[index] = this.getParameter(parameterDescriptors, parameterDescriptor, index);
            }
            catch (Exception e) {
                throw new ParameterException(parameterDescriptors.getSource() + " parameter index " + index + " descriptor " + parameterDescriptor, e);
            }
            ++index;
        }
        return args;
    }

    protected abstract Object getParameter(ParameterDescriptors var1, ParameterDescriptor var2, int var3) throws Exception;
}

