/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.factory.InstanceFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ClassInstanceIterator<E>
implements Iterator<E> {
    private final Iterator<Class<?>> iterator;
    private final InstanceFactory instanceFactory;
    private Class<?> service;

    public ClassInstanceIterator(InstanceFactory instanceFactory, Iterator<Class<?>> iterator) {
        this.instanceFactory = instanceFactory;
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        while (this.service == null) {
            if (this.iterator == null || !this.iterator.hasNext()) {
                return false;
            }
            this.service = this.iterator.next();
            if (this.service != null && this.instanceFactory.isInstance(this.service)) {
                return true;
            }
            this.service = null;
        }
        return true;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object instance = this.instanceFactory.getInstance(this.service);
        this.service = null;
        return (E)instance;
    }
}

