/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.factory.BeanDefinition;
import io.basc.framework.factory.BeanDefinitionFactory;
import io.basc.framework.factory.BeanDefinitionRegistry;
import io.basc.framework.factory.support.DefaultBeanDefinition;
import io.basc.framework.lang.AlreadyExistsException;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.StringUtils;
import io.basc.framework.util.alias.DefaultAliasRegistry;
import java.util.HashMap;
import java.util.Map;

public class DefaultBeanDefinitionRegistry
extends DefaultAliasRegistry
implements BeanDefinitionRegistry {
    private static Logger logger = LoggerFactory.getLogger(DefaultBeanDefinitionRegistry.class);
    private volatile Map<String, BeanDefinition> beanDefinitionMap = new HashMap<String, BeanDefinition>();
    private BeanDefinitionFactory parentBeanDefinitionFactory;

    @Nullable
    public BeanDefinitionFactory getParentBeanDefinitionFactory() {
        return this.parentBeanDefinitionFactory;
    }

    public void setParentBeanDefinitionFactory(BeanDefinitionFactory parentBeanDefinitionFactory) {
        this.parentBeanDefinitionFactory = parentBeanDefinitionFactory;
        this.setParentAliasFactory(parentBeanDefinitionFactory);
    }

    @Override
    public Object getDefinitionMutex() {
        return this.beanDefinitionMap;
    }

    @Override
    public BeanDefinition getDefinition(String name) {
        return this.getDefinition(name, this.getParentBeanDefinitionFactory());
    }

    protected BeanDefinition getDefinition(String name, BeanDefinitionFactory parent) {
        String[] aliases;
        BeanDefinition beanDefinition = this.beanDefinitionMap.get(name);
        if (beanDefinition == null && (aliases = this.getAliases(name)) != null) {
            String aliase;
            String[] stringArray = aliases;
            int n = stringArray.length;
            for (int i = 0; i < n && (beanDefinition = this.beanDefinitionMap.get(aliase = stringArray[i])) == null; ++i) {
            }
        }
        return beanDefinition != null || parent == null ? beanDefinition : parent.getDefinition(name);
    }

    @Override
    public BeanDefinition getDefinition(Class<?> clazz) {
        return this.getDefinition(clazz, this.getParentBeanDefinitionFactory());
    }

    protected BeanDefinition getDefinition(Class<?> clazz, BeanDefinitionFactory parent) {
        BeanDefinition definition = this.getDefinition(clazz.getName(), null);
        return definition != null || parent == null ? definition : parent.getDefinition(clazz);
    }

    @Override
    public final BeanDefinition registerDefinition(BeanDefinition beanDefinition) {
        return BeanDefinitionRegistry.super.registerDefinition(beanDefinition);
    }

    @Override
    public void registerAlias(String name, String alias) {
        super.registerAlias(name, alias);
        if (logger.isDebugEnabled()) {
            logger.debug("register alias {} name {}", alias, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanDefinition registerDefinition(String name, BeanDefinition beanDefinition) {
        if (logger.isDebugEnabled()) {
            logger.debug("register name=" + name + ", id=" + beanDefinition.getId() + ", names=" + beanDefinition.getNames());
        }
        Map<String, BeanDefinition> map = this.beanDefinitionMap;
        synchronized (map) {
            String id;
            if (!(beanDefinition.getId().equals(name) || beanDefinition.getNames().contains(name) || this.hasAlias(beanDefinition.getId(), name))) {
                this.registerAlias(beanDefinition.getId(), name);
            }
            BeanDefinition definitionToUse = beanDefinition;
            if (beanDefinition instanceof DefaultBeanDefinition) {
                DefaultBeanDefinition definition = (DefaultBeanDefinition)beanDefinition;
                if (!definition.isNew()) {
                    return beanDefinition;
                }
                definitionToUse = definition.clone();
            }
            if (this.beanDefinitionMap.containsKey(id = definitionToUse.getId())) {
                throw new AlreadyExistsException(definitionToUse.toString());
            }
            this.beanDefinitionMap.put(id, definitionToUse);
            if (logger.isDebugEnabled()) {
                logger.debug("register [{}] -> definition: {}", name, definitionToUse);
            }
            for (String alias : definitionToUse.getNames()) {
                if (alias.equals(name)) continue;
                this.registerAlias(id, alias);
            }
            return definitionToUse;
        }
    }

    @Override
    public final String[] getDefinitionIds() {
        return this.getDefinitionIds(this.getParentBeanDefinitionFactory());
    }

    public String[] getDefinitionIds(BeanDefinitionFactory parent) {
        String[] ids = StringUtils.toStringArray(this.beanDefinitionMap.keySet());
        return parent == null ? ids : ArrayUtils.merge(ids, parent.getDefinitionIds());
    }

    @Override
    public final boolean containsDefinition(String beanName) {
        return this.containsDefinition(beanName, this.getParentBeanDefinitionFactory());
    }

    public boolean containsDefinition(String beanName, BeanDefinitionFactory parent) {
        String[] aliases;
        if (this.beanDefinitionMap.containsKey(beanName)) {
            return true;
        }
        for (String name : aliases = this.getAliases(beanName)) {
            if (!this.beanDefinitionMap.containsKey(name)) continue;
            return true;
        }
        return parent == null ? false : parent.containsDefinition(beanName);
    }
}

