/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.aop.ConfigurableAop;
import io.basc.framework.aop.support.DefaultConfigurableAop;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.factory.BeanDefinition;
import io.basc.framework.factory.BeanFactory;
import io.basc.framework.factory.BeanFactoryAware;
import io.basc.framework.factory.BeanFactoryPostProcessor;
import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ConfigurableBeanFactory;
import io.basc.framework.factory.ConfigurableServices;
import io.basc.framework.factory.FactoryException;
import io.basc.framework.factory.FactoryLoader;
import io.basc.framework.factory.Init;
import io.basc.framework.factory.InstanceFactory;
import io.basc.framework.factory.support.BeanDefinitionLoader;
import io.basc.framework.factory.support.BeanDefinitionLoaderChain;
import io.basc.framework.factory.support.DefaultServiceLoaderFactory;
import io.basc.framework.factory.support.InstanceParameterFactory;
import io.basc.framework.factory.support.RegisterBeanDefinition;
import io.basc.framework.factory.support.RuntimeBean;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.util.Services;
import java.util.function.Supplier;

public class DefaultBeanFactory
extends DefaultServiceLoaderFactory
implements ConfigurableBeanFactory,
Init,
BeanDefinitionLoader {
    private static Logger logger = LoggerFactory.getLogger(DefaultBeanFactory.class);
    private final DefaultConfigurableAop aop = new DefaultConfigurableAop();
    private final ConfigurableServices<BeanDefinitionLoader> beanDefinitionLoaders = new ConfigurableServices<BeanDefinitionLoader>(BeanDefinitionLoader.class);
    private final ConfigurableServices<BeanFactoryPostProcessor> beanFactoryPostProcessors = new ConfigurableServices<BeanFactoryPostProcessor>(BeanFactoryPostProcessor.class);
    private volatile boolean initialized = false;
    private BeanFactory parent;

    public DefaultBeanFactory() {
        this.beanDefinitionLoaders.setAfterService(this);
        this.aop.addAopPolicy(instance -> RuntimeBean.getRuntimeBean(instance) != null);
        this.registerSingleton(BeanFactory.class.getName(), this);
        this.registerAlias(BeanFactory.class.getName(), InstanceFactory.class.getName());
        ((Services)((Object)this.getBeanResolver())).addService(new InstanceParameterFactory(this));
    }

    @Override
    protected void _dependence(Object instance, BeanDefinition definition) throws FactoryException {
        super._dependence(instance, definition);
        if (instance instanceof BeanFactoryAware) {
            ((BeanFactoryAware)instance).setBeanFactory(this);
        }
    }

    @Override
    protected void _init(Object instance, BeanDefinition definition) throws FactoryException {
        if (instance instanceof Configurable && !((Configurable)instance).isConfigured()) {
            ((Configurable)instance).configure(this);
        }
        super._init(instance, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        DefaultBeanFactory defaultBeanFactory = this;
        synchronized (defaultBeanFactory) {
            if (!this.isInitialized()) {
                throw new FactoryException("The bean factory has not been initialized");
            }
            logger.debug("Start destroy bean factory[{}]!", this);
            super.destroy();
            logger.debug("Destroyed bean factory[{}]!", this);
        }
    }

    @Override
    public ConfigurableAop getAop() {
        return this.aop;
    }

    public ConfigurableServices<BeanDefinitionLoader> getBeanDefinitionLoaders() {
        return this.beanDefinitionLoaders;
    }

    public ConfigurableServices<BeanFactoryPostProcessor> getBeanFactoryPostProcessors() {
        return this.beanFactoryPostProcessors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanDefinition getDefinition(ClassLoader classLoader, String name) {
        BeanDefinition definition = super.getDefinition(name);
        if (definition == null) {
            Object object = this.getDefinitionMutex();
            synchronized (object) {
                definition = super.getDefinition(name);
                if (definition == null) {
                    definition = new BeanDefinitionLoaderChain(this.beanDefinitionLoaders.iterator()).load(this, classLoader, name);
                    if (definition == null || !definition.isInstance()) {
                        for (String aliase : this.getAliases(name)) {
                            BeanDefinition aliaseDefinition = this.getDefinition(aliase);
                            if (aliaseDefinition == null || !aliaseDefinition.isInstance()) continue;
                            definition = aliaseDefinition;
                            break;
                        }
                    }
                    if (definition != null) {
                        definition = this.registerDefinition(name, definition);
                    }
                }
            }
        }
        return definition;
    }

    @Override
    public final BeanDefinition getDefinition(String name) {
        return this.getDefinition(this.getClassLoader(), name);
    }

    @Override
    public final BeanDefinition getDefinition(Class<?> clazz) {
        BeanDefinition definition = super.getDefinition(clazz);
        if (definition != null) {
            return definition;
        }
        return this.getDefinition(clazz.getClassLoader(), clazz.getName());
    }

    @Override
    public <T> T getInstance(Class<? extends T> clazz) throws FactoryException {
        if (this.parent != null && !this.containsDefinition(clazz.getName()) && !super.isInstance(clazz) && this.parent.isInstance(clazz)) {
            return this.parent.getInstance(clazz);
        }
        return super.getInstance(clazz);
    }

    @Override
    public <T> T getInstance(Class<? extends T> type, Class<?>[] parameterTypes, Object ... params) {
        if (this.parent != null && !this.containsDefinition(type.getName()) && !this.isInstance(type.getName(), (BeanDefinition e) -> e.isInstance(parameterTypes)) && this.parent.isInstance(type, parameterTypes)) {
            return this.parent.getInstance(type, parameterTypes, params);
        }
        return (T)this.getInstance(type.getName(), parameterTypes, params);
    }

    @Override
    public <T> T getInstance(Class<? extends T> type, Object ... params) {
        if (this.parent != null && !this.containsDefinition(type.getName()) && !this.isInstance(type.getName(), (BeanDefinition e) -> e.isInstance(params)) && this.parent.isInstance(type, params)) {
            return this.parent.getInstance(type, params);
        }
        return (T)this.getInstance(type.getName(), params);
    }

    @Override
    public Object getInstance(String name) throws FactoryException {
        if (this.parent != null && !this.containsDefinition(name) && !super.isInstance(name) && this.parent.isInstance(name)) {
            return this.parent.getInstance(name);
        }
        return super.getInstance(name);
    }

    @Override
    public Object getInstance(String name, Class<?>[] parameterTypes, Object ... params) {
        if (this.parent != null && !this.containsDefinition(name) && !this.isInstance(name, (BeanDefinition e) -> e.isInstance(parameterTypes)) && this.parent.isInstance(name, parameterTypes)) {
            return this.parent.getInstance(name, parameterTypes, params);
        }
        return this.getInstance(name, (BeanDefinition e) -> e.create(parameterTypes, params));
    }

    @Override
    public Object getInstance(String name, Object ... params) {
        if (this.parent != null && !this.containsDefinition(name) && !this.isInstance(name, (BeanDefinition e) -> e.isInstance(params)) && this.parent.isInstance(name, params)) {
            return this.parent.getInstance(name, params);
        }
        return this.getInstance(name, (BeanDefinition e) -> e.create(params));
    }

    @Override
    public BeanFactory getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        DefaultBeanFactory defaultBeanFactory = this;
        synchronized (defaultBeanFactory) {
            if (this.isInitialized()) {
                throw new FactoryException("The bean factory has been initialized");
            }
            try {
                logger.debug("Start initializing bean factory[{}]!", this);
                if (this.parent == null) {
                    this.setParentBeanFactory(FactoryLoader.bind(this.getClassLoader(), this));
                }
                if (!this.beanFactoryPostProcessors.isConfigured()) {
                    this.beanFactoryPostProcessors.configure(this);
                }
                if (!((ConfigurableServices)((Object)this.getBeanResolver())).isConfigured()) {
                    ((ConfigurableServices)((Object)this.getBeanResolver())).configure(this);
                }
                if (!this.beanDefinitionLoaders.isConfigured()) {
                    this.beanDefinitionLoaders.configure(this);
                }
                for (BeanFactoryPostProcessor postProcessor : this.beanFactoryPostProcessors) {
                    postProcessor.postProcessBeanFactory(this);
                }
                this.aop.configure(this);
                logger.debug("Started bean factory[{}]!", this);
            }
            finally {
                this.initialized = true;
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isInstance(Class<?> clazz) {
        return super.isInstance(clazz) || this.parent != null && !this.containsDefinition(clazz.getName()) && this.parent.isInstance(clazz);
    }

    @Override
    public boolean isInstance(Class<?> clazz, Class<?> ... parameterTypes) {
        return this.isInstance(clazz.getName(), parameterTypes) || this.parent != null && !this.containsDefinition(clazz.getName()) && this.parent.isInstance(clazz, parameterTypes);
    }

    @Override
    public boolean isInstance(Class<?> clazz, Object ... params) {
        return this.isInstance(clazz.getName(), params) || this.parent != null && !this.containsDefinition(clazz.getName()) && this.parent.isInstance(clazz, params);
    }

    @Override
    public boolean isInstance(String name) {
        return super.isInstance(name) || this.parent != null && !this.containsDefinition(name) && this.parent.isInstance(name);
    }

    @Override
    public boolean isInstance(String name, Class<?> ... parameterTypes) {
        return this.isInstance(name, (BeanDefinition e) -> e.isInstance(parameterTypes)) || this.parent != null && !this.containsDefinition(name) && this.parent.isInstance(name, parameterTypes);
    }

    @Override
    public boolean isInstance(String name, Object ... params) {
        return this.isInstance(name, (BeanDefinition e) -> e.isInstance()) || this.parent != null && !this.containsDefinition(name) && this.parent.isInstance(name, params);
    }

    @Override
    public BeanDefinition load(BeanFactory beanFactory, ClassLoader classLoader, String name, BeanDefinitionLoaderChain chain) throws FactoryException {
        return chain.load(beanFactory, classLoader, name);
    }

    @Override
    public BeanDefinition register(String id, TypeDescriptor typeDescriptor, boolean singleton, Supplier<Boolean> isInstanceSupplier, Supplier<?> supplier) {
        return this.registerDefinition(new RegisterBeanDefinition(this, typeDescriptor, id, singleton, isInstanceSupplier, supplier));
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        if (this.isInitialized()) {
            throw new FactoryException("Already initialized");
        }
        super.setClassLoader(classLoader);
        this.setParentBeanFactory(FactoryLoader.bind(classLoader, this));
    }

    public void setParentBeanFactory(BeanFactory parent) {
        FactoryLoader.getParentBeanFactory(parent, this).assertSuccess();
        this.parent = parent;
    }
}

