/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.factory.ConfigurableServiceLoaderFactory;
import io.basc.framework.factory.support.DefaultInstanceFactory;
import io.basc.framework.factory.support.SpiServiceLoader;
import io.basc.framework.util.DefaultServiceLoader;
import io.basc.framework.util.Registration;
import io.basc.framework.util.ServiceLoader;
import java.util.HashMap;
import java.util.Map;

public class DefaultServiceLoaderFactory
extends DefaultInstanceFactory
implements ConfigurableServiceLoaderFactory {
    private final Map<Class<?>, DefaultServiceLoader<?>> serviceLoaderMap = new HashMap();

    protected <S> ServiceLoader<S> getBeforeServiceLoader(Class<S> serviceClass) {
        return this.getConfigurableServiceLoader(serviceClass);
    }

    protected <S> ServiceLoader<S> getAfterServiceLoader(Class<S> serviceClass) {
        return new SpiServiceLoader<S>(serviceClass, this);
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(Class<S> serviceClass) {
        return ServiceLoader.concat(this.getBeforeServiceLoader(serviceClass), this.getAfterServiceLoader(serviceClass));
    }

    public <S> DefaultServiceLoader<S> getConfigurableServiceLoader(Class<? extends S> serviceClass) {
        return this.serviceLoaderMap.get(serviceClass);
    }

    @Override
    public <T> Registration registerService(Class<? extends T> type, T service) {
        DefaultServiceLoader<Object> serviceLoader = this.getConfigurableServiceLoader(type);
        if (serviceLoader == null) {
            serviceLoader = new DefaultServiceLoader();
        }
        return serviceLoader.register(service);
    }
}

