/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.factory.support;

import io.basc.framework.factory.InstanceFactory;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class InstanceIterator<E>
implements Iterator<E> {
    private final InstanceFactory instanceFactory;
    private final Iterator<String> iterator;
    private String name;

    public InstanceIterator(InstanceFactory instanceFactory, Iterator<String> iterator) {
        this.instanceFactory = instanceFactory;
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        while (this.name == null) {
            if (this.iterator == null || !this.iterator.hasNext()) {
                return false;
            }
            this.name = this.iterator.next();
            if (this.name != null && this.instanceFactory.isInstance(this.name)) {
                return true;
            }
            this.name = null;
        }
        return true;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object instance = this.instanceFactory.getInstance(this.name);
        this.name = null;
        return (E)instance;
    }
}

