/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.gson;

import io.basc.framework.convert.ConversionException;
import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.gson.Gson;
import io.basc.framework.gson.GsonArray;
import io.basc.framework.gson.GsonObject;
import io.basc.framework.gson.JsonElement;
import io.basc.framework.json.AbstractJsonElement;
import io.basc.framework.json.JsonArray;
import io.basc.framework.json.JsonObject;

public final class GsonElement
extends AbstractJsonElement {
    private JsonElement gsonJsonElement;
    private Gson gson;

    public GsonElement(JsonElement gsonJsonElement, Gson gson) {
        this.gsonJsonElement = gsonJsonElement;
        this.gson = gson;
    }

    @Override
    public Object getSource() {
        return this.gsonJsonElement;
    }

    @Override
    public String getAsString() {
        if (this.gsonJsonElement.isJsonArray() || this.gsonJsonElement.isJsonObject()) {
            return this.gsonJsonElement.toString();
        }
        return this.gsonJsonElement.getAsString();
    }

    @Override
    public JsonArray getAsJsonArray() {
        return new GsonArray(this.gsonJsonElement.getAsJsonArray(), this.gson);
    }

    @Override
    public JsonObject getAsJsonObject() {
        return new GsonObject(this.gsonJsonElement.getAsJsonObject(), this.gson);
    }

    @Override
    public boolean isJsonArray() {
        return this.gsonJsonElement.isJsonArray();
    }

    @Override
    public boolean isJsonObject() {
        return this.gsonJsonElement.isJsonObject();
    }

    @Override
    public String toJsonString() {
        if (this.gsonJsonElement.isJsonArray() || this.gsonJsonElement.isJsonObject()) {
            return this.gsonJsonElement.toString();
        }
        return this.gsonJsonElement.getAsString();
    }

    public int hashCode() {
        return this.gsonJsonElement.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof GsonElement) {
            return this.gsonJsonElement.equals(((GsonElement)obj).gsonJsonElement);
        }
        return false;
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) throws ConversionException {
        return this.gson.fromJson(this.gsonJsonElement, targetType.getResolvableType().getType());
    }
}

