/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.gson;

import io.basc.framework.gson.ExtendGsonTypeAdapter;
import io.basc.framework.gson.Gson;
import io.basc.framework.gson.GsonBuilder;
import io.basc.framework.gson.GsonElement;
import io.basc.framework.gson.JsonElement;
import io.basc.framework.json.AbstractJsonSupport;
import io.basc.framework.json.JsonException;
import java.io.IOException;
import java.io.Reader;

public final class GsonSupport
extends AbstractJsonSupport {
    public static final GsonSupport INSTANCE = new GsonSupport();
    private final Gson gson;

    public GsonSupport() {
        this.gson = new GsonBuilder().registerTypeAdapterFactory(ExtendGsonTypeAdapter.FACTORY).create();
    }

    public GsonSupport(Gson gson) {
        this.gson = gson;
    }

    public Gson getGson() {
        return this.gson;
    }

    @Override
    public io.basc.framework.json.JsonElement parseJson(String text) {
        JsonElement gsonJsonElement = this.gson.fromJson(text, JsonElement.class);
        return new GsonElement(gsonJsonElement, this.gson);
    }

    @Override
    public io.basc.framework.json.JsonElement parseJson(Reader reader) throws IOException, JsonException {
        JsonElement gsonJsonElement = this.gson.fromJson(reader, JsonElement.class);
        return new GsonElement(gsonJsonElement, this.gson);
    }

    @Override
    protected String toJsonStringInternal(Object obj) {
        return this.gson.toJson(obj);
    }
}

