/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.HttpMessage;
import io.basc.framework.http.MediaType;
import io.basc.framework.lang.Nullable;
import io.basc.framework.net.message.Entity;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.ObjectUtils;
import java.io.Serializable;

public class HttpEntity<T>
implements Entity<T>,
HttpMessage,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final HttpEntity<?> EMPTY = new HttpEntity();
    private final HttpHeaders headers;
    @Nullable
    private final T body;
    @Nullable
    private final TypeDescriptor typeDescriptor;

    protected HttpEntity() {
        this(null, null);
    }

    public HttpEntity(T body, TypeDescriptor bodyTypeDescriptor) {
        this(body, bodyTypeDescriptor, null);
    }

    public HttpEntity(MultiValueMap<String, String> headers) {
        this(null, null, headers);
    }

    public HttpEntity(T body, TypeDescriptor bodyTypeDescriptor, MultiValueMap<String, String> headers) {
        this.body = body;
        this.typeDescriptor = bodyTypeDescriptor;
        HttpHeaders tempHeaders = new HttpHeaders();
        if (headers != null) {
            tempHeaders.putAll(headers);
        }
        this.headers = tempHeaders;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public T getBody() {
        return this.body;
    }

    public boolean hasBody() {
        return this.body != null;
    }

    @Nullable
    public TypeDescriptor getTypeDescriptor() {
        T body;
        if (this.typeDescriptor == null && (body = this.getBody()) != null) {
            return TypeDescriptor.forObject(body);
        }
        return this.typeDescriptor;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        HttpEntity otherEntity = (HttpEntity)other;
        return ObjectUtils.equals(this.headers, otherEntity.headers) && ObjectUtils.equals(this.body, otherEntity.body);
    }

    public int hashCode() {
        return ObjectUtils.hashCode(this.headers) * 29 + ObjectUtils.hashCode(this.body);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        if (this.body != null) {
            builder.append(this.body);
            if (this.headers != null) {
                builder.append(',');
            }
        }
        if (this.headers != null) {
            builder.append(this.headers);
        }
        builder.append('>');
        return builder.toString();
    }

    @Override
    public MediaType getContentType() {
        return this.headers.getContentType();
    }
}

