/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http;

import io.basc.framework.env.Sys;
import io.basc.framework.event.support.StandardObservableMap;
import io.basc.framework.http.ContentDisposition;
import io.basc.framework.http.HttpMethod;
import io.basc.framework.http.HttpRange;
import io.basc.framework.http.MediaType;
import io.basc.framework.lang.Nullable;
import io.basc.framework.logger.Logger;
import io.basc.framework.logger.LoggerFactory;
import io.basc.framework.net.InetUtils;
import io.basc.framework.net.MimeType;
import io.basc.framework.net.MimeTypeUtils;
import io.basc.framework.net.message.Headers;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.Pair;
import io.basc.framework.util.StringMatchers;
import io.basc.framework.util.StringUtils;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpHeaders
extends Headers {
    private static Logger logger = LoggerFactory.getLogger(HttpHeaders.class);
    private static final long serialVersionUID = -8578554704772377436L;
    public static final HttpHeaders EMPTY = new HttpHeaders(Collections.emptyMap());
    public static final String ACCEPT = "Accept";
    public static final String ACCEPT_CHARSET = "Accept-Charset";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String ACCEPT_RANGES = "Accept-Ranges";
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    public static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    public static final String AGE = "Age";
    public static final String ALLOW = "Allow";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_RANGE = "Content-Range";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String COOKIE = "Cookie";
    public static final String DATE = "Date";
    public static final String ETAG = "ETag";
    public static final String EXPECT = "Expect";
    public static final String EXPIRES = "Expires";
    public static final String FROM = "From";
    public static final String HOST = "Host";
    public static final String IF_MATCH = "If-Match";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String IF_RANGE = "If-Range";
    public static final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String LINK = "Link";
    public static final String LOCATION = "Location";
    public static final String MAX_FORWARDS = "Max-Forwards";
    public static final String ORIGIN = "Origin";
    public static final String PRAGMA = "Pragma";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String RANGE = "Range";
    public static final String REFERER = "Referer";
    public static final String RETRY_AFTER = "Retry-After";
    public static final String SERVER = "Server";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SET_COOKIE2 = "Set-Cookie2";
    public static final String TE = "TE";
    public static final String TRAILER = "Trailer";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String UPGRADE = "Upgrade";
    public static final String USER_AGENT = "User-Agent";
    public static final String VARY = "Vary";
    public static final String VIA = "Via";
    public static final String WARNING = "Warning";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final Pattern ETAG_HEADER_VALUE_PATTERN = Pattern.compile("\\*|\\s*((W\\/)?(\"[^\"]*\"))\\s*,?");
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String[] DATE_FORMATS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy"};
    public static final String X_REQUESTED_WITH = "X-Requested-With";
    public static final String X_REAL_IP = "X-Real-Ip";
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final Function<Properties, Map<String, String[]>> CONVERTER = new Function<Properties, Map<String, String[]>>(){

        @Override
        public Map<String, String[]> apply(Properties properties) {
            if (CollectionUtils.isEmpty(properties)) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object[]> map = new LinkedHashMap<String, Object[]>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object[] values;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key == null || value == null || ArrayUtils.isEmpty(values = StringUtils.splitToArray(String.valueOf(value)))) continue;
                map.put(String.valueOf(key), values);
            }
            if (map.isEmpty()) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(map);
        }
    };
    private static final StandardObservableMap<String, String[]> AJAX_HEADERS = new StandardObservableMap();
    private static final String[] GET_IP_HEADERES;

    public HttpHeaders() {
        super(false);
    }

    public HttpHeaders(Map<String, List<String>> wrapperHeaders) {
        super(false);
        if (wrapperHeaders != null) {
            this.putAll(wrapperHeaders);
        }
    }

    public HttpHeaders(HttpHeaders httpHeaders) {
        super(httpHeaders);
    }

    public void setAccept(List<MediaType> acceptableMediaTypes) {
        this.set(ACCEPT, MediaType.toString(acceptableMediaTypes));
    }

    public List<MediaType> getAccept() {
        return MediaType.parseMediaTypes((List<String>)this.get(ACCEPT));
    }

    public void setAccessControlAllowCredentials(boolean allowCredentials) {
        this.set(ACCESS_CONTROL_ALLOW_CREDENTIALS, Boolean.toString(allowCredentials));
    }

    public boolean getAccessControlAllowCredentials() {
        return Boolean.parseBoolean(this.getFirst(ACCESS_CONTROL_ALLOW_CREDENTIALS));
    }

    public void setAccessControlAllowHeaders(List<String> allowedHeaders) {
        this.set(ACCESS_CONTROL_ALLOW_HEADERS, this.toCommaDelimitedString(allowedHeaders));
    }

    public List<String> getAccessControlAllowHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_ALLOW_HEADERS);
    }

    public void setAccessControlAllowMethods(List<HttpMethod> allowedMethods) {
        this.set(ACCESS_CONTROL_ALLOW_METHODS, StringUtils.collectionToCommaDelimitedString(allowedMethods));
    }

    public List<HttpMethod> getAccessControlAllowMethods() {
        ArrayList<HttpMethod> result = new ArrayList<HttpMethod>();
        String value = this.getFirst(ACCESS_CONTROL_ALLOW_METHODS);
        if (value != null) {
            String[] tokens;
            for (String token : tokens = StringUtils.tokenizeToArray(value, ",")) {
                HttpMethod resolved = HttpMethod.resolve(token);
                if (resolved == null) continue;
                result.add(resolved);
            }
        }
        return result;
    }

    public void setAccessControlAllowOrigin(String allowedOrigin) {
        this.set(ACCESS_CONTROL_ALLOW_ORIGIN, allowedOrigin);
    }

    public String getAccessControlAllowOrigin() {
        return this.getFieldValues(ACCESS_CONTROL_ALLOW_ORIGIN);
    }

    public void setAccessControlExposeHeaders(List<String> exposedHeaders) {
        this.set(ACCESS_CONTROL_EXPOSE_HEADERS, this.toCommaDelimitedString(exposedHeaders));
    }

    public List<String> getAccessControlExposeHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_EXPOSE_HEADERS);
    }

    public void setAccessControlMaxAge(long maxAge) {
        this.set(ACCESS_CONTROL_MAX_AGE, Long.toString(maxAge));
    }

    public long getAccessControlMaxAge() {
        String value = this.getFirst(ACCESS_CONTROL_MAX_AGE);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setAccessControlRequestHeaders(List<String> requestHeaders) {
        this.set(ACCESS_CONTROL_REQUEST_HEADERS, this.toCommaDelimitedString(requestHeaders));
    }

    public List<String> getAccessControlRequestHeaders() {
        return this.getValuesAsList(ACCESS_CONTROL_REQUEST_HEADERS);
    }

    public void setAccessControlRequestMethod(HttpMethod requestMethod) {
        this.set(ACCESS_CONTROL_REQUEST_METHOD, requestMethod.name());
    }

    public HttpMethod getAccessControlRequestMethod() {
        return HttpMethod.resolve(this.getFirst(ACCESS_CONTROL_REQUEST_METHOD));
    }

    public void setAcceptCharset(List<Charset> acceptableCharsets) {
        StringBuilder builder = new StringBuilder();
        Iterator<Charset> iterator = acceptableCharsets.iterator();
        while (iterator.hasNext()) {
            Charset charset = iterator.next();
            builder.append(charset.name().toLowerCase(Locale.ENGLISH));
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        this.set(ACCEPT_CHARSET, builder.toString());
    }

    public List<Charset> getAcceptCharset() {
        String value = this.getFirst(ACCEPT_CHARSET);
        if (value != null) {
            String[] tokens = StringUtils.tokenizeToArray(value, ",");
            ArrayList<Charset> result = new ArrayList<Charset>(tokens.length);
            for (String token : tokens) {
                int paramIdx = token.indexOf(59);
                String charsetName = paramIdx == -1 ? token : token.substring(0, paramIdx);
                if (charsetName.equals("*")) continue;
                result.add(Charset.forName(charsetName));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void setAllow(Set<HttpMethod> allowedMethods) {
        this.set(ALLOW, StringUtils.collectionToCommaDelimitedString(allowedMethods));
    }

    public Set<HttpMethod> getAllow() {
        String value = this.getFirst(ALLOW);
        if (!StringUtils.isEmpty(value)) {
            String[] tokens = StringUtils.tokenizeToArray(value, ",");
            ArrayList<HttpMethod> result = new ArrayList<HttpMethod>(tokens.length);
            for (String token : tokens) {
                HttpMethod resolved = HttpMethod.resolve(token);
                if (resolved == null) continue;
                result.add(resolved);
            }
            return EnumSet.copyOf(result);
        }
        return EnumSet.noneOf(HttpMethod.class);
    }

    public void setCacheControl(String cacheControl) {
        this.set(CACHE_CONTROL, cacheControl);
    }

    public String getCacheControl() {
        return this.getFieldValues(CACHE_CONTROL);
    }

    public void setConnection(String connection) {
        this.set(CONNECTION, connection);
    }

    public void setConnection(List<String> connection) {
        this.set(CONNECTION, this.toCommaDelimitedString(connection));
    }

    public List<String> getConnection() {
        return this.getValuesAsList(CONNECTION);
    }

    public void setContentDispositionFormData(String name, String filename) {
        Assert.notNull((Object)name, "'name' must not be null");
        StringBuilder builder = new StringBuilder("form-data; name=\"");
        builder.append(name).append('\"');
        if (filename != null) {
            builder.append("; filename=\"");
            builder.append(filename).append('\"');
        }
        this.set(CONTENT_DISPOSITION, builder.toString());
    }

    public void setContentDisposition(ContentDisposition contentDisposition) {
        this.set(CONTENT_DISPOSITION, contentDisposition.toString());
    }

    public ContentDisposition getContentDisposition() {
        String contentDisposition = this.getFirst(CONTENT_DISPOSITION);
        if (contentDisposition != null) {
            return ContentDisposition.parse(contentDisposition);
        }
        return ContentDisposition.empty();
    }

    public void setContentLength(long contentLength) {
        this.set(CONTENT_LENGTH, Long.toString(contentLength));
    }

    public long getContentLength() {
        String value = this.getFirst(CONTENT_LENGTH);
        return value != null ? Long.parseLong(value) : -1L;
    }

    public void setContentType(MediaType mediaType) {
        if (mediaType == null) {
            this.remove(CONTENT_TYPE);
            return;
        }
        Assert.isTrue(!mediaType.isWildcardType(), "Content-Type cannot contain wildcard type '*'");
        Assert.isTrue(!mediaType.isWildcardSubtype(), "Content-Type cannot contain wildcard subtype '*'");
        this.set(CONTENT_TYPE, mediaType.toString());
    }

    public MediaType getContentType() {
        String value = this.getFirst(CONTENT_TYPE);
        return StringUtils.isEmpty(value) ? null : MediaType.parseMediaType(value);
    }

    public void setDate(long date) {
        this.setDate(DATE, date);
    }

    public long getDate() {
        return this.getFirstDate(DATE);
    }

    public void setETag(String etag) {
        if (etag != null) {
            Assert.isTrue(etag.startsWith("\"") || etag.startsWith("W/"), "Invalid ETag: does not start with W/ or \"");
            Assert.isTrue(etag.endsWith("\""), "Invalid ETag: does not end with \"");
        }
        this.set(ETAG, etag);
    }

    public String getETag() {
        return this.getFirst(ETAG);
    }

    public void setExpires(long expires) {
        this.setDate(EXPIRES, expires);
    }

    public long getExpires() {
        return this.getFirstDate(EXPIRES, false);
    }

    public void setIfMatch(String ifMatch) {
        this.set(IF_MATCH, ifMatch);
    }

    public void setIfMatch(List<String> ifMatchList) {
        this.set(IF_MATCH, this.toCommaDelimitedString(ifMatchList));
    }

    public List<String> getIfMatch() {
        return this.getETagValuesAsList(IF_MATCH);
    }

    public void setIfModifiedSince(long ifModifiedSince) {
        this.setDate(IF_MODIFIED_SINCE, ifModifiedSince);
    }

    public long getIfModifiedSince() {
        return this.getFirstDate(IF_MODIFIED_SINCE, false);
    }

    public void setIfNoneMatch(String ifNoneMatch) {
        this.set(IF_NONE_MATCH, ifNoneMatch);
    }

    public void setIfNoneMatch(List<String> ifNoneMatchList) {
        this.set(IF_NONE_MATCH, this.toCommaDelimitedString(ifNoneMatchList));
    }

    public List<String> getIfNoneMatch() {
        return this.getETagValuesAsList(IF_NONE_MATCH);
    }

    public void setIfUnmodifiedSince(long ifUnmodifiedSince) {
        this.setDate(IF_UNMODIFIED_SINCE, ifUnmodifiedSince);
    }

    public long getIfUnmodifiedSince() {
        return this.getFirstDate(IF_UNMODIFIED_SINCE, false);
    }

    public void setLastModified(long lastModified) {
        this.setDate(LAST_MODIFIED, lastModified);
    }

    public long getLastModified() {
        return this.getFirstDate(LAST_MODIFIED, false);
    }

    public void setLocation(URI location) {
        this.set(LOCATION, location.toASCIIString());
    }

    public URI getLocation() {
        String value = this.getFirst(LOCATION);
        return value != null ? URI.create(value) : null;
    }

    public void setOrigin(String origin) {
        this.set(ORIGIN, origin);
    }

    public String getOrigin() {
        return this.getFirst(ORIGIN);
    }

    public void setPragma(String pragma) {
        this.set(PRAGMA, pragma);
    }

    public String getPragma() {
        return this.getFirst(PRAGMA);
    }

    public void setRange(List<HttpRange> ranges) {
        String value = HttpRange.toString(ranges);
        this.set(RANGE, value);
    }

    public List<HttpRange> getRange() {
        String value = this.getFirst(RANGE);
        return HttpRange.parseRanges(value);
    }

    public void setUpgrade(String upgrade) {
        this.set(UPGRADE, upgrade);
    }

    public String getUpgrade() {
        return this.getFirst(UPGRADE);
    }

    public void setVary(List<String> requestHeaders) {
        this.set(VARY, this.toCommaDelimitedString(requestHeaders));
    }

    public List<String> getVary() {
        return this.getValuesAsList(VARY);
    }

    public void setDate(String headerName, long date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMATS[0], Locale.US);
        dateFormat.setTimeZone(GMT);
        this.set(headerName, dateFormat.format(new Date(date)));
    }

    public long getFirstDate(String headerName) {
        return this.getFirstDate(headerName, true);
    }

    private long getFirstDate(String headerName, boolean rejectInvalid) {
        String headerValue = this.getFirst(headerName);
        if (headerValue == null) {
            return -1L;
        }
        if (headerValue.length() >= 3) {
            for (String dateFormat : DATE_FORMATS) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
                simpleDateFormat.setTimeZone(GMT);
                try {
                    return simpleDateFormat.parse(headerValue).getTime();
                }
                catch (ParseException parseException) {
                }
            }
        }
        if (rejectInvalid) {
            throw new IllegalArgumentException("Cannot parse date value \"" + headerValue + "\" for \"" + headerName + "\" header");
        }
        return -1L;
    }

    public List<String> getValuesAsList(String headerName) {
        return this.getValuesAsList(headerName, ",");
    }

    protected List<String> getETagValuesAsList(String headerName) {
        Object values = this.get(headerName);
        if (values != null) {
            ArrayList<String> result = new ArrayList<String>();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                if (value == null) continue;
                Matcher matcher = ETAG_HEADER_VALUE_PATTERN.matcher(value);
                while (matcher.find()) {
                    if ("*".equals(matcher.group())) {
                        result.add(matcher.group());
                        continue;
                    }
                    result.add(matcher.group(1));
                }
                if (!result.isEmpty()) continue;
                throw new IllegalArgumentException("Could not parse header '" + headerName + "' with value '" + value + "'");
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected String getFieldValues(String headerName) {
        Object headerValues = this.get(headerName);
        return headerValues != null ? this.toCommaDelimitedString((List<String>)headerValues) : null;
    }

    protected String toCommaDelimitedString(List<String> headerValues) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> it = headerValues.iterator();
        while (it.hasNext()) {
            String val = it.next();
            builder.append(val);
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @Override
    public String getFirst(String headerName) {
        Object headerValues = this.get(headerName);
        if (CollectionUtils.isEmpty(headerValues)) {
            return null;
        }
        return (String)headerValues.get(0);
    }

    @Override
    public void add(String headerName, String headerValue) {
        LinkedList<String> headerValues = this.get(headerName);
        if (headerValues == null) {
            headerValues = new LinkedList<String>();
            this.put(headerName, headerValues);
        }
        headerValues.add(headerValue);
    }

    @Override
    public void set(String headerName, String headerValue) {
        LinkedList<String> headerValues = new LinkedList<String>();
        headerValues.add(headerValue);
        this.put(headerName, headerValues);
    }

    @Override
    public void setAll(Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedHashMap<String, String> singleValueMap = new LinkedHashMap<String, String>(this.size());
        for (Map.Entry entry : this.entrySet()) {
            singleValueMap.put((String)entry.getKey(), (String)entry.getValue().get(0));
        }
        return singleValueMap;
    }

    public boolean isAjax() {
        for (Map.Entry entry : ((Map)AJAX_HEADERS.get()).entrySet()) {
            String key = (String)entry.getKey();
            if (ArrayUtils.isEmpty((Object[])entry.getValue()) || !this.matchHeaders(key, (List<String>)this.get(key), (String[])entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean matchHeaders(String name, List<String> values, String[] matchs) {
        for (String match : matchs) {
            if (match == null) continue;
            if (values == null) {
                if (!this.matchHeader(name, null, match)) continue;
                return true;
            }
            for (String value : values) {
                if (!this.matchHeader(name, value, match)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchHeader(String name, String value, String match) {
        boolean b = StringMatchers.SIMPLE.match(match, value);
        if (logger.isDebugEnabled()) {
            logger.debug("check ajax header name={}, value={}, match={}, result={}", name, value, match, b);
        }
        return b;
    }

    public boolean isFormContentType() {
        return this.isCompatibleWithContentType(MediaType.APPLICATION_FORM_URLENCODED);
    }

    public boolean isJsonContentType() {
        return this.isCompatibleWithContentType(MediaType.APPLICATION_JSON, MimeTypeUtils.TEXT_JSON);
    }

    public boolean isXmlContentType() {
        return this.isCompatibleWithContentType(MediaType.APPLICATION_XML, MediaType.TEXT_XML);
    }

    public boolean isMultipartFormContentType() {
        return this.isCompatibleWithContentType(MediaType.MULTIPART_FORM_DATA);
    }

    public boolean isCompatibleWithContentType(MimeType ... contentTypes) {
        if (contentTypes == null) {
            return false;
        }
        MediaType contentType = this.getContentType();
        if (contentType == null) {
            return false;
        }
        for (MimeType type : contentTypes) {
            if (!type.includes(contentType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getIp() {
        for (String name : GET_IP_HEADERES) {
            String[] ips;
            String value = this.getFirst(name);
            if (value == null) continue;
            for (String ip : ips = StringUtils.splitToArray((CharSequence)value, ",")) {
                InetAddress inetAddress;
                if (StringUtils.isEmpty(ip) || "unKnown".equals(ip) || InetUtils.isInnerIP(ip)) continue;
                try {
                    inetAddress = InetAddress.getByName(ip);
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (inetAddress.isMCGlobal()) continue;
                return inetAddress.getHostAddress();
            }
        }
        return null;
    }

    public void addHeaders(String ... headers) throws IllegalStateException {
        for (String header : headers) {
            if (StringUtils.isEmpty(header)) continue;
            Pair<String, String> hs = StringUtils.parseKV(header, ":");
            if (hs == null) {
                throw new IllegalStateException("error header [" + header + "]");
            }
            this.add(hs.getKey(), hs.getValue());
        }
    }

    static {
        try {
            AJAX_HEADERS.register(Sys.getEnv().getProperties("/io/basc/framework/net/headers/ajax.headers.properties").convert(CONVERTER));
        }
        catch (Throwable e) {
            logger.error(e, "Failed to load ajax.headers.properties file");
        }
        try {
            AJAX_HEADERS.register(Sys.getEnv().getProperties(Sys.getEnv().getProperties().get("io.basc.framework.net.ajax.headers").or("/ajax-headers.properties").getAsString()).convert(CONVERTER));
        }
        catch (Exception e) {
            logger.error(e, "Failed to load {io.basc.framework.net.ajax.headers} file");
        }
        GET_IP_HEADERES = new String[]{X_FORWARDED_FOR, X_REAL_IP};
    }
}

