/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.http.HttpEntity;
import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.HttpMethod;
import io.basc.framework.http.HttpRequest;
import io.basc.framework.http.MediaType;
import io.basc.framework.lang.Nullable;
import io.basc.framework.net.uri.UriUtils;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.ObjectUtils;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;

public class HttpRequestEntity<T>
extends HttpEntity<T>
implements HttpRequest {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final String method;
    private final URI url;

    public HttpRequestEntity(String method, URI url) {
        this(null, null, method, url, null);
    }

    public HttpRequestEntity(@Nullable T body, String method, URI url) {
        this(body, null, method, url, null);
    }

    public HttpRequestEntity(@Nullable T body, String method, URI url, TypeDescriptor typeDescriptor) {
        this(body, null, method, url, typeDescriptor);
    }

    public HttpRequestEntity(MultiValueMap<String, String> headers, String method, URI url) {
        this(null, headers, method, url, null);
    }

    public HttpRequestEntity(@Nullable T body, @Nullable MultiValueMap<String, String> headers, @Nullable String method, URI url) {
        this(body, headers, method, url, null);
    }

    public HttpRequestEntity(@Nullable T body, @Nullable MultiValueMap<String, String> headers, @Nullable String method, URI url, @Nullable TypeDescriptor typeDescriptor) {
        super(body, typeDescriptor, headers);
        this.method = method;
        this.url = url;
    }

    @Override
    @Nullable
    public String getRawMethod() {
        return this.method;
    }

    @Override
    public final URI getURI() {
        return this.url;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (other instanceof HttpRequestEntity) {
            HttpRequestEntity otherEntity = (HttpRequestEntity)other;
            return ObjectUtils.equals((Object)this.getMethod(), (Object)otherEntity.getMethod()) && ObjectUtils.equals(this.getURI(), otherEntity.getURI());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        hashCode = 29 * hashCode + ObjectUtils.hashCode(this.method);
        hashCode = 29 * hashCode + ObjectUtils.hashCode(this.url);
        return hashCode;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append((Object)this.getMethod());
        builder.append(' ');
        builder.append(this.getURI());
        builder.append(',');
        Object body = this.getBody();
        HttpHeaders headers = this.getHeaders();
        if (body != null) {
            builder.append(body);
            builder.append(',');
        }
        builder.append(headers);
        builder.append('>');
        return builder.toString();
    }

    public static BodyBuilder<?> method(HttpMethod method, URI url) {
        return new DefaultBodyBuilder(method, url);
    }

    public static BodyBuilder<?> method(HttpMethod method, String url) {
        return HttpRequestEntity.method(method, UriUtils.toUri(url));
    }

    public static HeadersBuilder<?> get(URI url) {
        return HttpRequestEntity.method(HttpMethod.GET, url);
    }

    public static HeadersBuilder<?> get(String url) {
        return HttpRequestEntity.get(UriUtils.toUri(url));
    }

    public static HeadersBuilder<?> head(URI url) {
        return HttpRequestEntity.method(HttpMethod.HEAD, url);
    }

    public static HeadersBuilder<?> head(String url) {
        return HttpRequestEntity.head(UriUtils.toUri(url));
    }

    public static BodyBuilder<?> post(URI url) {
        return HttpRequestEntity.method(HttpMethod.POST, url);
    }

    public static BodyBuilder<?> post(String url) {
        return HttpRequestEntity.post(UriUtils.toUri(url));
    }

    public static BodyBuilder<?> put(URI url) {
        return HttpRequestEntity.method(HttpMethod.PUT, url);
    }

    public static BodyBuilder<?> put(String url) {
        return HttpRequestEntity.put(UriUtils.toUri(url));
    }

    public static BodyBuilder<?> patch(URI url) {
        return HttpRequestEntity.method(HttpMethod.PATCH, url);
    }

    public static BodyBuilder<?> patch(String url) {
        return HttpRequestEntity.patch(UriUtils.toUri(url));
    }

    public static HeadersBuilder<?> delete(URI url) {
        return HttpRequestEntity.method(HttpMethod.DELETE, url);
    }

    public static HeadersBuilder<?> delete(String url) {
        return HttpRequestEntity.delete(UriUtils.toUri(url));
    }

    public static HeadersBuilder<?> options(URI url) {
        return HttpRequestEntity.method(HttpMethod.OPTIONS, url);
    }

    public static HeadersBuilder<?> options(String url) {
        return HttpRequestEntity.options(UriUtils.toUri(url));
    }

    private static class DefaultBodyBuilder
    implements BodyBuilder<DefaultBodyBuilder> {
        private final String method;
        private final URI url;
        private final HttpHeaders headers = new HttpHeaders();

        public DefaultBodyBuilder(HttpMethod method, URI url) {
            this(method.name(), url);
        }

        public DefaultBodyBuilder(String method, URI url) {
            this.method = method;
            this.url = url;
        }

        @Override
        public DefaultBodyBuilder header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.headers.add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public DefaultBodyBuilder headers(@Nullable HttpHeaders headers) {
            if (headers != null) {
                this.headers.putAll(headers);
            }
            return this;
        }

        @Override
        public DefaultBodyBuilder accept(MediaType ... acceptableMediaTypes) {
            this.headers.setAccept(Arrays.asList(acceptableMediaTypes));
            return this;
        }

        @Override
        public DefaultBodyBuilder acceptCharset(Charset ... acceptableCharsets) {
            this.headers.setAcceptCharset(Arrays.asList(acceptableCharsets));
            return this;
        }

        @Override
        public DefaultBodyBuilder contentLength(long contentLength) {
            this.headers.setContentLength(contentLength);
            return this;
        }

        @Override
        public DefaultBodyBuilder contentType(MediaType contentType) {
            this.headers.setContentType(contentType);
            return this;
        }

        @Override
        public DefaultBodyBuilder ifNoneMatch(String ... ifNoneMatches) {
            this.headers.setIfNoneMatch(Arrays.asList(ifNoneMatches));
            return this;
        }

        @Override
        public DefaultBodyBuilder ifModifiedSince(long ifModifiedSince) {
            this.headers.setIfModifiedSince(ifModifiedSince);
            return this;
        }

        @Override
        public <T> HttpRequestEntity<T> build() {
            return new HttpRequestEntity(this.headers, this.method, this.url);
        }

        @Override
        public <T> HttpRequestEntity<T> body(T body) {
            return new HttpRequestEntity<T>(body, this.headers, this.method, this.url);
        }

        @Override
        public <T> HttpRequestEntity<T> body(T body, TypeDescriptor typeDescriptor) {
            return new HttpRequestEntity<T>(body, this.headers, this.method, this.url, typeDescriptor);
        }
    }

    public static interface BodyBuilder<B extends BodyBuilder<B>>
    extends HeadersBuilder<B> {
        public B contentLength(long var1);

        public B contentType(MediaType var1);

        public <T> HttpRequestEntity<T> body(T var1);

        public <T> HttpRequestEntity<T> body(T var1, TypeDescriptor var2);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B headers(@Nullable HttpHeaders var1);

        public B accept(MediaType ... var1);

        public B acceptCharset(Charset ... var1);

        public B ifModifiedSince(long var1);

        public B ifNoneMatch(String ... var1);

        public <T> HttpRequestEntity<T> build();
    }
}

