/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.http.CacheControl;
import io.basc.framework.http.HttpEntity;
import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.HttpMethod;
import io.basc.framework.http.HttpStatus;
import io.basc.framework.http.MediaType;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.ObjectUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class HttpResponseEntity<T>
extends HttpEntity<T> {
    private static final long serialVersionUID = 1L;
    private final Object status;

    public HttpResponseEntity(HttpStatus status) {
        this(null, null, status);
    }

    public HttpResponseEntity(T body, TypeDescriptor bodyTypeDescriptor, HttpStatus status) {
        this(body, bodyTypeDescriptor, null, status);
    }

    public HttpResponseEntity(MultiValueMap<String, String> headers, HttpStatus status) {
        this(null, null, headers, status);
    }

    public HttpResponseEntity(T body, TypeDescriptor bodyTypeDescriptor, MultiValueMap<String, String> headers, HttpStatus status) {
        super(body, bodyTypeDescriptor, headers);
        Assert.notNull((Object)status, "HttpStatus must not be null");
        this.status = status;
    }

    private HttpResponseEntity(T body, TypeDescriptor bodyTypeDescriptor, MultiValueMap<String, String> headers, Object status) {
        super(body, bodyTypeDescriptor, headers);
        this.status = status;
    }

    public HttpStatus getStatusCode() {
        if (this.status instanceof HttpStatus) {
            return (HttpStatus)this.status;
        }
        return HttpStatus.valueOf((Integer)this.status);
    }

    public int getStatusCodeValue() {
        if (this.status instanceof HttpStatus) {
            return ((HttpStatus)this.status).value();
        }
        return (Integer)this.status;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        HttpResponseEntity otherEntity = (HttpResponseEntity)other;
        return ObjectUtils.equals(this.status, otherEntity.status);
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 29 + ObjectUtils.hashCode(this.status);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("<");
        builder.append(this.status.toString());
        if (this.status instanceof HttpStatus) {
            builder.append(' ');
            builder.append(((HttpStatus)this.status).getReasonPhrase());
        }
        builder.append(',');
        Object body = this.getBody();
        HttpHeaders headers = this.getHeaders();
        if (body != null) {
            builder.append(body);
            if (headers != null) {
                builder.append(',');
            }
        }
        if (headers != null) {
            builder.append(headers);
        }
        builder.append('>');
        return builder.toString();
    }

    public static BodyBuilder status(HttpStatus status) {
        Assert.notNull((Object)status, "HttpStatus must not be null");
        return new DefaultBuilder(status);
    }

    public static BodyBuilder status(int status) {
        return new DefaultBuilder(status);
    }

    public static BodyBuilder ok() {
        return HttpResponseEntity.status(HttpStatus.OK);
    }

    public static <T> HttpResponseEntity<T> ok(T body) {
        BodyBuilder builder = HttpResponseEntity.ok();
        return builder.body(body);
    }

    public static BodyBuilder created(URI location) {
        BodyBuilder builder = HttpResponseEntity.status(HttpStatus.CREATED);
        return (BodyBuilder)builder.location(location);
    }

    public static BodyBuilder accepted() {
        return HttpResponseEntity.status(HttpStatus.ACCEPTED);
    }

    public static HeadersBuilder<?> noContent() {
        return HttpResponseEntity.status(HttpStatus.NO_CONTENT);
    }

    public static BodyBuilder badRequest() {
        return HttpResponseEntity.status(HttpStatus.BAD_REQUEST);
    }

    public static HeadersBuilder<?> notFound() {
        return HttpResponseEntity.status(HttpStatus.NOT_FOUND);
    }

    public static BodyBuilder unprocessableEntity() {
        return HttpResponseEntity.status(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    private static class DefaultBuilder
    implements BodyBuilder {
        private final Object statusCode;
        private final HttpHeaders headers = new HttpHeaders();

        public DefaultBuilder(Object statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public BodyBuilder header(String headerName, String ... headerValues) {
            for (String headerValue : headerValues) {
                this.headers.add(headerName, headerValue);
            }
            return this;
        }

        @Override
        public BodyBuilder headers(HttpHeaders headers) {
            if (headers != null) {
                this.headers.putAll(headers);
            }
            return this;
        }

        @Override
        public BodyBuilder allow(HttpMethod ... allowedMethods) {
            this.headers.setAllow(new LinkedHashSet<HttpMethod>(Arrays.asList(allowedMethods)));
            return this;
        }

        @Override
        public BodyBuilder contentLength(long contentLength) {
            this.headers.setContentLength(contentLength);
            return this;
        }

        @Override
        public BodyBuilder contentType(MediaType contentType) {
            this.headers.setContentType(contentType);
            return this;
        }

        @Override
        public BodyBuilder eTag(String etag) {
            if (etag != null) {
                if (!etag.startsWith("\"") && !etag.startsWith("W/\"")) {
                    etag = "\"" + etag;
                }
                if (!etag.endsWith("\"")) {
                    etag = etag + "\"";
                }
            }
            this.headers.setETag(etag);
            return this;
        }

        @Override
        public BodyBuilder lastModified(long date) {
            this.headers.setLastModified(date);
            return this;
        }

        @Override
        public BodyBuilder location(URI location) {
            this.headers.setLocation(location);
            return this;
        }

        @Override
        public BodyBuilder cacheControl(CacheControl cacheControl) {
            String ccValue = cacheControl.getHeaderValue();
            if (ccValue != null) {
                this.headers.setCacheControl(ccValue);
            }
            return this;
        }

        @Override
        public BodyBuilder varyBy(String ... requestHeaders) {
            this.headers.setVary(Arrays.asList(requestHeaders));
            return this;
        }

        @Override
        public <T> HttpResponseEntity<T> build() {
            return this.body(null);
        }

        @Override
        public <T> HttpResponseEntity<T> body(T body, TypeDescriptor typeDescriptor) {
            return new HttpResponseEntity(body, typeDescriptor, this.headers, this.statusCode);
        }
    }

    public static interface BodyBuilder
    extends HeadersBuilder<BodyBuilder> {
        public BodyBuilder contentLength(long var1);

        public BodyBuilder contentType(MediaType var1);

        default public <T> HttpResponseEntity<T> body(T body) {
            return this.body(body, null);
        }

        public <T> HttpResponseEntity<T> body(T var1, @Nullable TypeDescriptor var2);
    }

    public static interface HeadersBuilder<B extends HeadersBuilder<B>> {
        public B header(String var1, String ... var2);

        public B headers(HttpHeaders var1);

        public B allow(HttpMethod ... var1);

        public B eTag(String var1);

        public B lastModified(long var1);

        public B location(URI var1);

        public B cacheControl(CacheControl var1);

        public B varyBy(String ... var1);

        public <T> HttpResponseEntity<T> build();
    }
}

