/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.factory.Configurable;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.http.HttpRequest;
import io.basc.framework.http.HttpRequestEntity;
import io.basc.framework.http.HttpResponseEntity;
import io.basc.framework.http.client.ClientHttpRequest;
import io.basc.framework.http.client.ClientHttpRequestCallback;
import io.basc.framework.http.client.ClientHttpRequestFactory;
import io.basc.framework.http.client.ClientHttpRequestInterceptor;
import io.basc.framework.http.client.ClientHttpRequestInterceptorChain;
import io.basc.framework.http.client.ClientHttpResponse;
import io.basc.framework.http.client.ClientHttpResponseErrorHandler;
import io.basc.framework.http.client.ClientHttpResponseExtractor;
import io.basc.framework.http.client.HttpClient;
import io.basc.framework.http.client.HttpClientConnection;
import io.basc.framework.http.client.HttpClientErrorException;
import io.basc.framework.http.client.HttpClientException;
import io.basc.framework.http.client.HttpClientResourceAccessException;
import io.basc.framework.http.client.HttpConnection;
import io.basc.framework.http.client.MessageConverterClientHttpRequestCallback;
import io.basc.framework.http.client.MessageConverterClientHttpResponseExtractor;
import io.basc.framework.http.client.RedirectManager;
import io.basc.framework.lang.Nullable;
import io.basc.framework.net.message.convert.MessageConverter;
import io.basc.framework.net.uri.DefaultUriTemplateHandler;
import io.basc.framework.net.uri.UriTemplateHandler;
import io.basc.framework.retry.RetryOperations;
import io.basc.framework.util.CollectionUtils;
import io.basc.framework.util.MultiValueMap;
import io.basc.framework.util.Pair;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpClient
implements HttpClient,
Configurable {
    private ClientHttpRequestFactory requestFactory;
    private CookieHandler cookieHandler;
    private RedirectManager redirectManager;
    private boolean cloneBeforeSet = true;
    private UriTemplateHandler uriTemplateHandler;
    private ClientHttpResponseErrorHandler responseErrorHandler;
    private ClientHttpRequestInterceptor interceptor;
    private MessageConverter messageConverter;
    private RetryOperations retryOperations;
    private boolean configured;

    public AbstractHttpClient(ClientHttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
    }

    public AbstractHttpClient(AbstractHttpClient configurable) {
        this.requestFactory = configurable.requestFactory;
        this.cookieHandler = configurable.cookieHandler;
        this.redirectManager = configurable.redirectManager;
        this.cloneBeforeSet = configurable.cloneBeforeSet;
        this.uriTemplateHandler = configurable.uriTemplateHandler;
        this.responseErrorHandler = configurable.responseErrorHandler;
        this.interceptor = configurable.interceptor;
        this.messageConverter = configurable.messageConverter;
    }

    public boolean isCloneBeforeSet() {
        return this.cloneBeforeSet;
    }

    public void setCloneBeforeSet(boolean cloneBeforeSet) {
        this.cloneBeforeSet = cloneBeforeSet;
    }

    @Nullable
    public RetryOperations getRetryOperations() {
        return this.retryOperations;
    }

    public void setRetryOperations(RetryOperations retryOperations) {
        this.retryOperations = retryOperations;
    }

    @Override
    public abstract AbstractHttpClient clone();

    @Override
    public boolean isConfigured() {
        return this.configured;
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        if (serviceLoaderFactory.isInstance(ClientHttpRequestFactory.class)) {
            this.requestFactory = serviceLoaderFactory.getInstance(ClientHttpRequestFactory.class);
        }
        if (serviceLoaderFactory.isInstance(CookieHandler.class)) {
            this.cookieHandler = serviceLoaderFactory.getInstance(CookieHandler.class);
        }
        if (serviceLoaderFactory.isInstance(RedirectManager.class)) {
            this.redirectManager = serviceLoaderFactory.getInstance(RedirectManager.class);
        }
        if (serviceLoaderFactory.isInstance(UriTemplateHandler.class)) {
            this.uriTemplateHandler = serviceLoaderFactory.getInstance(UriTemplateHandler.class);
        }
        if (serviceLoaderFactory.isInstance(ClientHttpResponseErrorHandler.class)) {
            this.responseErrorHandler = serviceLoaderFactory.getInstance(ClientHttpResponseErrorHandler.class);
        }
        if (serviceLoaderFactory.isInstance(RetryOperations.class)) {
            this.retryOperations = serviceLoaderFactory.getInstance(RetryOperations.class);
        }
        this.configured = true;
    }

    public UriTemplateHandler getUriTemplateHandler() {
        return this.uriTemplateHandler == null ? DefaultUriTemplateHandler.INSTANCE : this.uriTemplateHandler;
    }

    public void setUriTemplateHandler(UriTemplateHandler uriTemplateHandler) {
        this.uriTemplateHandler = uriTemplateHandler;
    }

    public ClientHttpResponseErrorHandler getResponseErrorHandler() {
        return this.responseErrorHandler;
    }

    public void setResponseErrorHandler(ClientHttpResponseErrorHandler responseErrorHandler) {
        this.responseErrorHandler = responseErrorHandler;
    }

    public ClientHttpRequestInterceptor getInterceptor() {
        return this.interceptor;
    }

    public void setInterceptor(ClientHttpRequestInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Override
    public ClientHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public AbstractHttpClient setRequestFactory(ClientHttpRequestFactory requestFactory) {
        AbstractHttpClient client = this.isCloneBeforeSet() ? this.clone() : this;
        client.requestFactory = requestFactory;
        return client;
    }

    @Override
    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    @Override
    public AbstractHttpClient setCookieHandler(CookieHandler cookieHandler) {
        AbstractHttpClient client = this.isCloneBeforeSet() ? this.clone() : this;
        client.cookieHandler = cookieHandler;
        return client;
    }

    @Override
    public RedirectManager getRedirectManager() {
        return this.redirectManager;
    }

    @Override
    public AbstractHttpClient setRedirectManager(RedirectManager redirectManager) {
        AbstractHttpClient client = this.isCloneBeforeSet() ? this.clone() : this;
        client.redirectManager = redirectManager;
        return client;
    }

    @Override
    public HttpConnection createConnection(String httpMethod, URI uri) {
        HttpClientConnection connection = new HttpClientConnection(uri, httpMethod, this);
        connection.setCloneBeforeSet(true);
        return connection;
    }

    @Override
    public final HttpConnection createConnection(String httpMethod, String uriTemplate, Map<String, ?> uriVariables) {
        URI uri = this.getUriTemplateHandler().expand(uriTemplate, uriVariables);
        return this.createConnection(httpMethod, uri);
    }

    @Override
    public final HttpConnection createConnection(String httpMethod, String uriTemplate, Object ... uriVariables) {
        URI uri = this.getUriTemplateHandler().expand(uriTemplate, uriVariables);
        return this.createConnection(httpMethod, uri);
    }

    @Override
    public final <T> HttpResponseEntity<T> execute(ClientHttpRequest request, CookieHandler cookieHandler, ClientHttpResponseExtractor<T> responseExtractor) throws HttpClientException, IOException {
        return this.execute(request, cookieHandler, responseExtractor, null);
    }

    protected <T> HttpResponseEntity<T> execute(ClientHttpRequest request, CookieHandler cookieHandler, ClientHttpResponseExtractor<T> responseExtractor, @Nullable TypeDescriptor responseType) throws HttpClientException, IOException {
        ClientHttpRequestInterceptor interceptor;
        Map<String, List<String>> map;
        ClientHttpResponse response = null;
        if (cookieHandler != null && !CollectionUtils.isEmpty(map = cookieHandler.get(request.getURI(), request.getHeaders()))) {
            request.getHeaders().addAll(map);
        }
        if ((interceptor = this.getInterceptor()) == null) {
            response = request.execute();
        } else {
            ClientHttpRequestInterceptorChain chain = new ClientHttpRequestInterceptorChain(Arrays.asList(interceptor).iterator());
            response = chain.execute(request);
        }
        this.handleResponse(request, response);
        if (cookieHandler != null) {
            cookieHandler.put(request.getURI(), response.getHeaders());
        }
        T body = this.responseExtractor(request, response, responseExtractor);
        return new HttpResponseEntity<T>(body, responseType, (MultiValueMap<String, String>)response.getHeaders(), response.getStatusCode());
    }

    protected void handleResponse(ClientHttpRequest request, ClientHttpResponse response) throws IOException {
        ClientHttpResponseErrorHandler errorHandler = this.getResponseErrorHandler();
        if (errorHandler == null) {
            return;
        }
        boolean hasError = errorHandler.hasError(response);
        if (hasError) {
            errorHandler.handleError(response);
        }
    }

    protected <T> T responseExtractor(ClientHttpRequest request, ClientHttpResponse response, ClientHttpResponseExtractor<T> clientResponseExtractor) throws IOException {
        return clientResponseExtractor == null ? null : (T)clientResponseExtractor.execute(request, response);
    }

    @Override
    public final <T> HttpResponseEntity<T> execute(URI uri, String httpMethod, ClientHttpRequestFactory requestFactory, CookieHandler cookieHandler, ClientHttpRequestCallback requestCallback, RedirectManager redirectManager, ClientHttpResponseExtractor<T> responseExtractor) {
        return this.execute(uri, httpMethod, requestFactory, cookieHandler, requestCallback, redirectManager, responseExtractor, null);
    }

    protected <T> HttpResponseEntity<T> execute(URI uri, String httpMethod, ClientHttpRequestFactory requestFactory, CookieHandler cookieHandler, ClientHttpRequestCallback requestCallback, RedirectManager redirectManager, ClientHttpResponseExtractor<T> responseExtractor, TypeDescriptor responseType) {
        return this.execute(uri, httpMethod, requestFactory, cookieHandler, requestCallback, redirectManager, responseExtractor, responseType, 0L);
    }

    private <T> HttpResponseEntity<T> execute(URI uri, String httpMethod, ClientHttpRequestFactory requestFactory, CookieHandler cookieHandler, ClientHttpRequestCallback requestCallback, RedirectManager redirectManager, ClientHttpResponseExtractor<T> responseExtractor, TypeDescriptor responseType, long deep) {
        RetryOperations retryOperations = this.getRetryOperations();
        Pair response = retryOperations == null ? this.executeInternal(uri, httpMethod, requestFactory, cookieHandler, requestCallback, responseExtractor, responseType) : retryOperations.execute(context -> {
            try {
                return this.executeInternal(uri, httpMethod, requestFactory, cookieHandler, requestCallback, responseExtractor, responseType);
            }
            catch (HttpClientErrorException e) {
                throw e;
            }
            catch (Throwable e) {
                context.setExhaustedOnly();
                throw e;
            }
        });
        if (redirectManager == null) {
            return (HttpResponseEntity)response.getValue();
        }
        URI redirectUri = redirectManager.getRedirect((HttpRequest)response.getKey(), (HttpResponseEntity)response.getValue(), deep);
        if (redirectUri == null) {
            return (HttpResponseEntity)response.getValue();
        }
        return this.execute(redirectUri, httpMethod, requestFactory, cookieHandler, requestCallback, redirectManager, responseExtractor, responseType, deep + 1L);
    }

    private <T> Pair<HttpRequest, HttpResponseEntity<T>> executeInternal(URI uri, String httpMethod, ClientHttpRequestFactory requestFactory, CookieHandler cookieHandler, ClientHttpRequestCallback requestCallback, ClientHttpResponseExtractor<T> responseExtractor, TypeDescriptor responseType) throws HttpClientException {
        try {
            ClientHttpRequest request = requestFactory.createRequest(uri, httpMethod);
            request = this.requestCallback(request, requestCallback);
            HttpResponseEntity<T> responseEntity = this.execute(request, cookieHandler, responseExtractor, responseType);
            return new Pair<HttpRequest, HttpResponseEntity<T>>(request, responseEntity);
        }
        catch (IOException e) {
            throw new HttpClientResourceAccessException("I/O error on " + httpMethod + " request for \"" + uri + "\": " + e.getMessage(), e);
        }
    }

    protected ClientHttpRequest requestCallback(ClientHttpRequest request, ClientHttpRequestCallback requestCallback) throws IOException {
        if (requestCallback != null) {
            return requestCallback.callback(request);
        }
        return request;
    }

    @Override
    public final <T> HttpResponseEntity<T> execute(ClientHttpRequest request, CookieHandler cookieHandler, TypeDescriptor responseType) throws HttpClientException, IOException {
        return this.execute(request, cookieHandler, new MessageConverterClientHttpResponseExtractor(this.getMessageConverter(), responseType), responseType);
    }

    @Override
    public final <T> HttpResponseEntity<T> execute(HttpRequestEntity<?> requestEntity, ClientHttpRequestFactory requestFactory, CookieHandler cookieHandler, RedirectManager redirectManager, ClientHttpResponseExtractor<T> responseExtractor) {
        return this.execute(requestEntity.getURI(), requestEntity.getRawMethod(), requestFactory, cookieHandler, (ClientHttpRequestCallback)new MessageConverterClientHttpRequestCallback(this.getMessageConverter(), requestEntity), redirectManager, responseExtractor);
    }

    @Override
    public final <T> HttpResponseEntity<T> execute(HttpRequestEntity<?> requestEntity, ClientHttpRequestFactory requestFactory, CookieHandler cookieHandler, RedirectManager redirectManager, TypeDescriptor responseType) {
        return this.execute(requestEntity.getURI(), requestEntity.getRawMethod(), requestFactory, cookieHandler, new MessageConverterClientHttpRequestCallback(this.getMessageConverter(), requestEntity), redirectManager, new MessageConverterClientHttpResponseExtractor(this.getMessageConverter(), responseType), responseType);
    }

    @Override
    public final <T> HttpResponseEntity<T> execute(URI uri, String httpMethod, ClientHttpRequestFactory requestFactory, CookieHandler cookieHandler, ClientHttpRequestCallback requestCallback, RedirectManager redirectManager, TypeDescriptor responseType) {
        return this.execute(uri, httpMethod, requestFactory, cookieHandler, requestCallback, redirectManager, new MessageConverterClientHttpResponseExtractor(this.getMessageConverter(), responseType), responseType);
    }
}

