/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.convert.TypeDescriptor;
import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.MediaType;
import io.basc.framework.http.client.ClientHttpRequestFactory;
import io.basc.framework.http.client.HttpConnection;
import io.basc.framework.http.client.RedirectManager;
import io.basc.framework.lang.Nullable;
import java.net.CookieHandler;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class AbstractHttpConnection
implements HttpConnection {
    private ClientHttpRequestFactory requestFactory;
    private CookieHandler cookieHandler;
    private RedirectManager redirectManager;
    private String httpMethod;
    private URI uri;
    private final HttpHeaders headers;
    @Nullable
    private Object body;
    @Nullable
    private TypeDescriptor typeDescriptor;
    private boolean cloneBeforeSet;

    public AbstractHttpConnection(URI uri, String httpMethod) {
        this.uri = uri;
        this.httpMethod = httpMethod;
        this.headers = new HttpHeaders();
    }

    public AbstractHttpConnection(AbstractHttpConnection connection) {
        this.requestFactory = connection.requestFactory;
        this.cookieHandler = connection.cookieHandler;
        this.redirectManager = connection.redirectManager;
        this.httpMethod = connection.httpMethod;
        this.uri = connection.uri;
        this.headers = new HttpHeaders(connection.headers);
        this.body = connection.body;
        this.typeDescriptor = connection.typeDescriptor;
        this.cloneBeforeSet = connection.cloneBeforeSet;
    }

    public boolean isCloneBeforeSet() {
        return this.cloneBeforeSet;
    }

    public void setCloneBeforeSet(boolean cloneBeforeSet) {
        this.cloneBeforeSet = cloneBeforeSet;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public String getRawMethod() {
        return this.httpMethod;
    }

    @Override
    public abstract AbstractHttpConnection clone();

    @Override
    public HttpConnection header(String headerName, String ... headerValues) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        for (String headerValue : headerValues) {
            connection.headers.add(headerName, headerValue);
        }
        return connection;
    }

    @Override
    public HttpConnection headers(@Nullable HttpHeaders headers) {
        AbstractHttpConnection connection;
        AbstractHttpConnection abstractHttpConnection = connection = this.isCloneBeforeSet() ? this.clone() : this;
        if (headers != null) {
            connection.headers.putAll(headers);
        }
        return connection;
    }

    @Override
    public HttpConnection accept(MediaType ... acceptableMediaTypes) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.headers.setAccept(Arrays.asList(acceptableMediaTypes));
        return connection;
    }

    @Override
    public HttpConnection acceptCharset(Charset ... acceptableCharsets) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.headers.setAcceptCharset(Arrays.asList(acceptableCharsets));
        return connection;
    }

    @Override
    public HttpConnection contentLength(long contentLength) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.headers.setContentLength(contentLength);
        return connection;
    }

    @Override
    public HttpConnection contentType(MediaType contentType) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.headers.setContentType(contentType);
        return connection;
    }

    @Override
    public HttpConnection ifNoneMatch(String ... ifNoneMatches) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.headers.setIfNoneMatch(Arrays.asList(ifNoneMatches));
        return connection;
    }

    @Override
    public HttpConnection ifModifiedSince(long ifModifiedSince) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.headers.setIfModifiedSince(ifModifiedSince);
        return connection;
    }

    @Override
    public HttpConnection body(Object body, TypeDescriptor typeDescriptor) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.body = body;
        connection.typeDescriptor = typeDescriptor;
        return connection;
    }

    @Override
    public Object getBody() {
        return this.body;
    }

    @Override
    public TypeDescriptor getTypeDescriptor() {
        if (this.typeDescriptor == null && this.body != null) {
            return TypeDescriptor.forObject(this.body);
        }
        return this.typeDescriptor;
    }

    @Override
    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    @Override
    public HttpConnection setCookieHandler(CookieHandler cookieHandler) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.cookieHandler = cookieHandler;
        return connection;
    }

    @Override
    public RedirectManager getRedirectManager() {
        return this.redirectManager;
    }

    @Override
    public HttpConnection setRedirectManager(RedirectManager redirectManager) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.redirectManager = redirectManager;
        return connection;
    }

    @Override
    public ClientHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public HttpConnection setRequestFactory(ClientHttpRequestFactory requestFactory) {
        AbstractHttpConnection connection = this.isCloneBeforeSet() ? this.clone() : this;
        connection.requestFactory = requestFactory;
        return connection;
    }
}

