/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.http.client.ClientHttpRequest;
import io.basc.framework.http.client.ClientHttpRequestExecutor;
import io.basc.framework.http.client.ClientHttpRequestInterceptor;
import io.basc.framework.http.client.ClientHttpResponse;
import io.basc.framework.lang.Nullable;
import java.io.IOException;
import java.util.Iterator;

public class ClientHttpRequestInterceptorChain
implements ClientHttpRequestExecutor {
    private Iterator<ClientHttpRequestInterceptor> iterator;
    private ClientHttpRequestExecutor nextChain;

    public ClientHttpRequestInterceptorChain(@Nullable Iterator<ClientHttpRequestInterceptor> iterator) {
        this(iterator, null);
    }

    public ClientHttpRequestInterceptorChain(@Nullable Iterator<ClientHttpRequestInterceptor> iterator, @Nullable ClientHttpRequestExecutor nextChain) {
        this.iterator = iterator;
        this.nextChain = nextChain;
    }

    @Override
    public ClientHttpResponse execute(ClientHttpRequest request) throws IOException {
        ClientHttpRequestInterceptor interceptor = this.getNextInterceptor(request);
        if (interceptor == null) {
            if (this.nextChain == null) {
                return request.execute();
            }
            return this.nextChain.execute(request);
        }
        return interceptor.intercept(request, this);
    }

    protected ClientHttpRequestInterceptor getNextInterceptor(ClientHttpRequest request) {
        if (this.iterator == null) {
            return null;
        }
        while (this.iterator.hasNext()) {
            ClientHttpRequestInterceptor interceptor = this.iterator.next();
            if (interceptor == null) continue;
            return interceptor;
        }
        return null;
    }
}

