/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.HttpStatus;
import io.basc.framework.http.MediaType;
import io.basc.framework.http.client.ClientHttpResponse;
import io.basc.framework.http.client.ClientHttpResponseErrorHandler;
import io.basc.framework.http.client.HttpClientErrorException;
import io.basc.framework.http.client.HttpServerErrorException;
import io.basc.framework.http.client.UnknownHttpStatusCodeException;
import io.basc.framework.io.IOUtils;
import io.basc.framework.net.message.Headers;
import java.io.IOException;
import java.nio.charset.Charset;

public class DefaultClientHttpResponseErrorHandler
implements ClientHttpResponseErrorHandler {
    public static final ClientHttpResponseErrorHandler INSTANCE = new DefaultClientHttpResponseErrorHandler();

    @Override
    public boolean hasError(ClientHttpResponse response) throws IOException {
        int rawStatusCode = response.getRawStatusCode();
        HttpStatus httpStatus = HttpStatus.valueOf(rawStatusCode);
        if (httpStatus == null) {
            return this.hasError(rawStatusCode);
        }
        return this.hasError(httpStatus);
    }

    protected boolean hasError(HttpStatus statusCode) {
        return statusCode.is4xxClientError() || statusCode.is5xxServerError();
    }

    protected boolean hasError(int unknownStatusCode) {
        int seriesCode = unknownStatusCode / 100;
        return seriesCode == HttpStatus.Series.CLIENT_ERROR.value() || seriesCode == HttpStatus.Series.SERVER_ERROR.value();
    }

    @Override
    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = this.getHttpStatusCode(response);
        switch (statusCode.series()) {
            case CLIENT_ERROR: {
                throw new HttpClientErrorException(statusCode, response.getStatusText(), (HttpHeaders)response.getHeaders(), this.getResponseBody(response), this.getCharset(response));
            }
            case SERVER_ERROR: {
                throw new HttpServerErrorException(statusCode, response.getStatusText(), (HttpHeaders)response.getHeaders(), this.getResponseBody(response), this.getCharset(response));
            }
        }
        throw new UnknownHttpStatusCodeException(statusCode.value(), response.getStatusText(), (HttpHeaders)response.getHeaders(), this.getResponseBody(response), this.getCharset(response));
    }

    protected HttpStatus getHttpStatusCode(ClientHttpResponse response) throws IOException {
        try {
            return response.getStatusCode();
        }
        catch (IllegalArgumentException ex) {
            throw new UnknownHttpStatusCodeException(response.getRawStatusCode(), response.getStatusText(), (HttpHeaders)response.getHeaders(), this.getResponseBody(response), this.getCharset(response));
        }
    }

    protected byte[] getResponseBody(ClientHttpResponse response) {
        try {
            return IOUtils.copyToByteArray(response.getInputStream());
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    protected Charset getCharset(ClientHttpResponse response) {
        Headers headers = response.getHeaders();
        MediaType contentType = ((HttpHeaders)headers).getContentType();
        return contentType != null ? contentType.getCharset() : null;
    }
}

