/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.env.Sys;
import io.basc.framework.factory.ServiceLoaderFactory;
import io.basc.framework.http.client.AbstractHttpClient;
import io.basc.framework.http.client.ClientHttpRequestFactory;
import io.basc.framework.http.client.ClientHttpRequestInterceptors;
import io.basc.framework.http.client.DefaultClientHttpResponseErrorHandler;
import io.basc.framework.net.message.convert.DefaultMessageConverters;
import io.basc.framework.net.message.convert.MessageConverters;

public class DefaultHttpClient
extends AbstractHttpClient {
    private static final ClientHttpRequestFactory REQUEST_FACTORY = (ClientHttpRequestFactory)Sys.getEnv().getServiceLoader(ClientHttpRequestFactory.class, "io.basc.framework.http.client.SimpleClientHttpRequestFactory").first();
    private final MessageConverters messageConverters;
    private final ClientHttpRequestInterceptors interceptors;
    private boolean configured = false;

    public DefaultHttpClient() {
        super(REQUEST_FACTORY);
        this.messageConverters = new DefaultMessageConverters();
        this.interceptors = new ClientHttpRequestInterceptors();
        super.setInterceptor(this.interceptors);
        this.setMessageConverter(this.messageConverters);
        this.setResponseErrorHandler(DefaultClientHttpResponseErrorHandler.INSTANCE);
    }

    protected DefaultHttpClient(DefaultHttpClient client) {
        super(client);
        this.messageConverters = client.messageConverters;
        this.interceptors = client.interceptors;
        this.configured = client.configured;
    }

    @Override
    public void configure(ServiceLoaderFactory serviceLoaderFactory) {
        this.configured = true;
        this.interceptors.configure(serviceLoaderFactory);
        this.messageConverters.configure(serviceLoaderFactory);
        super.configure(serviceLoaderFactory);
    }

    public final ClientHttpRequestInterceptors getInterceptors() {
        return this.interceptors;
    }

    public MessageConverters getMessageConverters() {
        return this.messageConverters;
    }

    @Override
    public DefaultHttpClient clone() {
        return new DefaultHttpClient(this);
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }
}

