/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.HttpRequest;
import io.basc.framework.http.HttpResponseEntity;
import io.basc.framework.http.HttpStatus;
import io.basc.framework.http.client.ClientHttpResponse;
import io.basc.framework.http.client.RedirectManager;
import java.io.IOException;
import java.net.URI;

public class DefaultHttpRedirectManager
implements RedirectManager {
    private final long maxDeep;

    public DefaultHttpRedirectManager() {
        this(3L);
    }

    public DefaultHttpRedirectManager(long maxDeep) {
        this.maxDeep = maxDeep;
    }

    public URI getRedirect(HttpRequest request, ClientHttpResponse response, long deep) throws IOException {
        return this.getLocation(response.getStatusCode(), (HttpHeaders)response.getHeaders(), deep);
    }

    @Override
    public URI getRedirect(HttpRequest request, HttpResponseEntity<?> responseEntity, long deep) {
        return this.getLocation(responseEntity.getStatusCode(), responseEntity.getHeaders(), deep);
    }

    public URI getLocation(HttpStatus statusCode, HttpHeaders httpHeaders, long deep) {
        if (deep < 0L) {
            return null;
        }
        if (this.maxDeep >= 0L && deep >= this.maxDeep) {
            return null;
        }
        if (statusCode == HttpStatus.MOVED_PERMANENTLY || statusCode == HttpStatus.FOUND) {
            URI location = httpHeaders.getLocation();
            if (location != null) {
                return location;
            }
            return location;
        }
        return null;
    }
}

