/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.http.HttpEntity;
import io.basc.framework.http.client.ClientHttpRequest;
import io.basc.framework.http.client.ClientHttpRequestCallback;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.net.message.convert.MessageConverter;
import java.io.IOException;

public class MessageConverterClientHttpRequestCallback
implements ClientHttpRequestCallback {
    private final MessageConverter messageConverter;
    private final HttpEntity<?> httpEntity;

    public MessageConverterClientHttpRequestCallback(MessageConverter messageConverter, HttpEntity<?> httpEntity) {
        this.messageConverter = messageConverter;
        this.httpEntity = httpEntity;
    }

    @Override
    public ClientHttpRequest callback(ClientHttpRequest clientRequest) throws IOException {
        if (this.httpEntity == null) {
            return null;
        }
        if (this.httpEntity.getHeaders() != null) {
            clientRequest.getHeaders().putAll(this.httpEntity.getHeaders());
        }
        if (this.httpEntity.hasBody() && clientRequest.getMethod().hasRequestBody()) {
            if (this.messageConverter == null || !this.messageConverter.canWrite(this.httpEntity.getTypeDescriptor(), this.httpEntity.getBody(), this.httpEntity.getContentType())) {
                throw new UnsupportedException("not supported write " + this.httpEntity);
            }
            this.messageConverter.write(this.httpEntity.getTypeDescriptor(), this.httpEntity.getBody(), this.httpEntity.getContentType(), clientRequest);
        }
        return clientRequest;
    }
}

