/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.http.client;

import io.basc.framework.http.HttpHeaders;
import io.basc.framework.http.client.AbstractClientHttpRequest;
import io.basc.framework.http.client.ClientHttpResponse;
import io.basc.framework.http.client.SimpleBufferingClientHttpRequest;
import io.basc.framework.http.client.SimpleClientHttpResponse;
import io.basc.framework.io.IOUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;

final class SimpleStreamingClientHttpRequest
extends AbstractClientHttpRequest {
    private final HttpURLConnection connection;
    private final int chunkSize;
    private OutputStream body;
    private final boolean outputStreaming;

    SimpleStreamingClientHttpRequest(HttpURLConnection connection, int chunkSize, boolean outputStreaming) {
        this.connection = connection;
        this.chunkSize = chunkSize;
        this.outputStreaming = outputStreaming;
    }

    @Override
    public String getRawMethod() {
        return this.connection.getRequestMethod();
    }

    @Override
    public URI getURI() {
        try {
            return this.connection.getURL().toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get HttpURLConnection URI: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        if (this.body == null) {
            if (this.outputStreaming) {
                int contentLength = (int)headers.getContentLength();
                if (contentLength >= 0) {
                    this.connection.setFixedLengthStreamingMode(contentLength);
                } else {
                    this.connection.setChunkedStreamingMode(this.chunkSize);
                }
            }
            SimpleBufferingClientHttpRequest.addHeaders(this.connection, headers);
            this.connection.connect();
            this.body = this.connection.getOutputStream();
        }
        return IOUtils.nonClosing(this.body);
    }

    @Override
    protected ClientHttpResponse executeInternal(HttpHeaders headers) throws IOException {
        try {
            if (this.body != null) {
                this.body.close();
            } else {
                SimpleBufferingClientHttpRequest.addHeaders(this.connection, headers);
                this.connection.connect();
                this.connection.getResponseCode();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new SimpleClientHttpResponse(this.connection);
    }
}

