/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.core.reflect.ReflectionUtils;
import io.basc.framework.event.AbstractObservable;
import io.basc.framework.event.BroadcastEventDispatcher;
import io.basc.framework.event.EventListener;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourceUtils;
import io.basc.framework.io.SimpleResourceEventDispatcher;
import io.basc.framework.lang.NestedIOException;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.util.Assert;
import io.basc.framework.util.JavaVersion;
import io.basc.framework.util.Registration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public abstract class AbstractResource
extends AbstractObservable<Resource>
implements Resource,
BroadcastEventDispatcher<ObservableChangeEvent<Resource>> {
    private static final Constructor<BroadcastEventDispatcher<ObservableChangeEvent<Resource>>> WATCH_SERVICE_CONSTRUCTOR = ReflectionUtils.getDeclaredConstructor("io.basc.framework.io.WatchServiceResourceEventDispatcher", null, AbstractResource.class);
    private volatile BroadcastEventDispatcher<ObservableChangeEvent<Resource>> eventDispatcher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BroadcastEventDispatcher<ObservableChangeEvent<Resource>> getEventDispatcher() {
        if (this.eventDispatcher == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.eventDispatcher == null) {
                    if (JavaVersion.INSTANCE.getMasterVersion() >= 7) {
                        this.eventDispatcher = ReflectionUtils.newInstance(WATCH_SERVICE_CONSTRUCTOR, this);
                    }
                    if (this.eventDispatcher == null) {
                        this.eventDispatcher = new SimpleResourceEventDispatcher(this);
                    }
                }
            }
        }
        return this.eventDispatcher;
    }

    protected boolean isObserableJar() {
        return false;
    }

    public boolean isObservable() {
        if (this.exists()) {
            try {
                if (ResourceUtils.isJarURL(this.getURL())) {
                    return this.isObserableJar();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public Registration registerListener(EventListener<ObservableChangeEvent<Resource>> eventListener) {
        if (!this.isObservable()) {
            return Registration.EMPTY;
        }
        return this.getEventDispatcher().registerListener(eventListener);
    }

    @Override
    public void publishEvent(ObservableChangeEvent<Resource> event) {
        this.getEventDispatcher().publishEvent(event);
    }

    @Override
    public boolean exists() {
        try {
            return this.getFile().exists();
        }
        catch (IOException ex) {
            try {
                this.getInputStream().close();
                return true;
            }
            catch (Throwable isEx) {
                return false;
            }
        }
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL");
    }

    @Override
    public URI getURI() throws IOException {
        URL url = this.getURL();
        try {
            return ResourceUtils.toURI(url);
        }
        catch (URISyntaxException ex) {
            throw new NestedIOException("Invalid URI [" + url + "]", ex);
        }
    }

    @Override
    public File getFile() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to absolute file path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long contentLength() throws IOException {
        InputStream is = this.getInputStream();
        Assert.state(is != null, "Resource InputStream must not be null");
        try {
            int read;
            long size = 0L;
            byte[] buf = new byte[256];
            while ((read = is.read(buf)) != -1) {
                size += (long)read;
            }
            long l = size;
            return l;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public long lastModified() throws IOException {
        File fileToCheck = this.getFileForLastModifiedCheck();
        long lastModified = fileToCheck.lastModified();
        if (lastModified == 0L && !fileToCheck.exists()) {
            throw new FileNotFoundException(this.getDescription() + " cannot be resolved in the file system for checking its last-modified timestamp");
        }
        return lastModified;
    }

    protected File getFileForLastModifiedCheck() throws IOException {
        return this.getFile();
    }

    @Override
    public Resource createRelative(String relativePath) throws IOException {
        throw new FileNotFoundException("Cannot create a relative resource for " + this.getDescription());
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof Resource && ((Resource)obj).getDescription().equals(this.getDescription());
    }

    @Override
    public int hashCode() {
        return this.getDescription().hashCode();
    }

    public boolean isWritable() {
        return false;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedException(this.getDescription());
    }

    @Override
    public Resource getValue() {
        return this.exists() ? this : null;
    }
}

