/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class Bits {
    private Bits() {
    }

    public static boolean getBoolean(byte[] b, int off) {
        return b[off] != 0;
    }

    public static boolean readBoolean(InputStream source) throws IOException {
        int value = source.read();
        if (value == -1) {
            throw new EOFException();
        }
        return value != 0;
    }

    public static char getChar(byte[] b, int off) {
        return (char)((b[off + 1] & 0xFF) + (b[off] << 8));
    }

    public static short getShort(byte[] b, int off) {
        return (short)((b[off + 1] & 0xFF) + (b[off] << 8));
    }

    public static short readShort(InputStream source) throws EOFException, IOException {
        byte[] buff = new byte[2];
        int size = source.read(buff);
        if (size != buff.length) {
            throw new EOFException("read buff=" + Arrays.toString(buff) + ", size=" + size);
        }
        return Bits.getShort(buff, 0);
    }

    public static int getInt(byte[] b, int off) {
        return (b[off + 3] & 0xFF) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + (b[off] << 24);
    }

    public static int readInt(InputStream source) throws IOException {
        byte[] buff = new byte[4];
        int size = source.read(buff);
        if (size != buff.length) {
            throw new EOFException("read buff=" + Arrays.toString(buff) + ", size=" + size);
        }
        return Bits.getInt(buff, 0);
    }

    public static float getFloat(byte[] b, int off) {
        return Float.intBitsToFloat(Bits.getInt(b, off));
    }

    public static long getLong(byte[] b, int off) {
        return ((long)b[off + 7] & 0xFFL) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + ((long)b[off] << 56);
    }

    public static long readLong(InputStream source) throws IOException {
        byte[] buff = new byte[8];
        int size = source.read(buff);
        if (size != buff.length) {
            throw new EOFException("read buff=" + Arrays.toString(buff) + ", size=" + size);
        }
        return Bits.getLong(buff, 0);
    }

    public static double getDouble(byte[] b, int off) {
        return Double.longBitsToDouble(Bits.getLong(b, off));
    }

    public static void putBoolean(byte[] b, int off, boolean val) {
        b[off] = (byte)(val ? 1 : 0);
    }

    public static void writeBoolean(boolean source, OutputStream target) throws IOException {
        target.write(source ? 1 : 0);
    }

    public static void putChar(byte[] b, int off, char val) {
        b[off + 1] = (byte)val;
        b[off] = (byte)(val >>> 8);
    }

    public static void putShort(byte[] b, int off, short val) {
        b[off + 1] = (byte)val;
        b[off] = (byte)(val >>> 8);
    }

    public static void writeShort(short source, OutputStream target) throws IOException {
        byte[] buff = new byte[2];
        Bits.putShort(buff, 0, source);
        target.write(buff);
    }

    public static void putInt(byte[] b, int off, int val) {
        b[off + 3] = (byte)val;
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off] = (byte)(val >>> 24);
    }

    public static void writeInt(int source, OutputStream target) throws IOException {
        byte[] buff = new byte[4];
        Bits.putInt(buff, 0, source);
        target.write(buff);
    }

    public static void putFloat(byte[] b, int off, float val) {
        Bits.putInt(b, off, Float.floatToIntBits(val));
    }

    public static void putLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)val;
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off] = (byte)(val >>> 56);
    }

    public static void writeLong(long source, OutputStream target) throws IOException {
        byte[] buff = new byte[8];
        Bits.putLong(buff, 0, source);
        target.write(buff);
    }

    public static void putDouble(byte[] b, int off, double val) {
        Bits.putLong(b, off, Double.doubleToLongBits(val));
    }
}

