/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.LocationClassesLoader;
import io.basc.framework.io.ResourcePatternResolver;
import io.basc.framework.util.StaticSupplier;
import java.util.function.Supplier;

public class ClassPathClassesLoader
extends LocationClassesLoader {
    public static String cleanPath(String path) {
        return path.startsWith("classpath:") || path.startsWith("classpath*:") ? path : "classpath*:" + path;
    }

    public ClassPathClassesLoader(ResourcePatternResolver resourcePatternResolver, String classPath) {
        this(resourcePatternResolver, new StaticSupplier<String>(classPath));
    }

    public ClassPathClassesLoader(ResourcePatternResolver resourcePatternResolver, Supplier<String> classPathSupplier) {
        super(resourcePatternResolver, () -> {
            String path = (String)classPathSupplier.get();
            if (path == null) {
                return null;
            }
            return ClassPathClassesLoader.cleanPath(path);
        });
    }
}

