/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.codec.Codec;
import io.basc.framework.codec.support.RecordCodec;
import io.basc.framework.io.RecordIterator;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Creator;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.XUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public final class FileRecords<T>
implements Iterable<T> {
    private final Creator<? extends File, ? extends IOException> lazyCreator;
    private volatile File file;
    private final RecordCodec<T> codec;

    public FileRecords(Codec<T, byte[]> codec) {
        this(() -> File.createTempFile("records", XUtils.getUUID()), codec);
    }

    public FileRecords(File file, Codec<T, byte[]> codec) {
        this(() -> file, codec);
    }

    public FileRecords(Creator<? extends File, ? extends IOException> lazyCreator, Codec<T, byte[]> codec) {
        Assert.requiredArgument(lazyCreator != null, "lazyCreator");
        Assert.requiredArgument(codec != null, "codec");
        this.lazyCreator = lazyCreator;
        this.codec = new RecordCodec<T>(codec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile() throws IOException {
        if (this.file == null) {
            FileRecords fileRecords = this;
            synchronized (fileRecords) {
                if (this.file == null) {
                    this.file = this.lazyCreator.create();
                }
            }
        }
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete() {
        if (this.file == null) return false;
        FileRecords fileRecords = this;
        synchronized (fileRecords) {
            boolean bl;
            if (this.file == null) return false;
            try {
                bl = this.file.delete();
                this.file = null;
            }
            catch (Throwable throwable) {
                this.file = null;
                throw throwable;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cursor<T> iterator() {
        if (this.file != null) {
            FileRecords fileRecords = this;
            synchronized (fileRecords) {
                if (this.file != null) {
                    RecordIterator<T> iterator = new RecordIterator<T>(this.file, this.codec);
                    return Cursor.of(iterator);
                }
            }
        }
        return Cursor.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> void consume(ConsumeProcessor<? super T, ? extends E> consumer) throws E {
        Assert.requiredArgument(consumer != null, "consumer");
        if (this.file != null) {
            FileRecords fileRecords = this;
            synchronized (fileRecords) {
                if (this.file != null) {
                    try (RecordIterator<T> iterator = new RecordIterator<T>(this.file, this.codec);){
                        while (iterator.hasNext()) {
                            consumer.process(iterator.next());
                        }
                    }
                }
            }
        }
    }

    public void append(T record) throws IOException {
        if (record == null) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(this.getFile(), true);){
            this.codec.encode(record, fos);
        }
    }
}

