/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.ContextResource;
import io.basc.framework.io.DefaultResourceLoader;
import io.basc.framework.io.FileSystemResource;
import io.basc.framework.io.Resource;
import io.basc.framework.io.Resources;

public class FileSystemResourceLoader
extends DefaultResourceLoader {
    @Override
    protected Resource getResourceByPath(String path) {
        FileSystemContextResource fileSystemResource = new FileSystemContextResource(path);
        if (this.ignoreClassPathResource(fileSystemResource)) {
            return fileSystemResource;
        }
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        Resource resource = super.getResourceByPath(path);
        Resources resources = new Resources();
        resources.register(fileSystemResource);
        resources.register(resource);
        return resources;
    }

    protected boolean ignoreClassPathResource(FileSystemResource resource) {
        return resource.exists();
    }

    private static class FileSystemContextResource
    extends FileSystemResource
    implements ContextResource {
        public FileSystemContextResource(String path) {
            super(path);
        }

        @Override
        public String getPathWithinContext() {
            return this.getPath();
        }
    }
}

