/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.BufferProcessor;
import io.basc.framework.io.LimitedInputStream;
import io.basc.framework.io.LineIterator;
import io.basc.framework.io.UnsafeByteArrayInputStream;
import io.basc.framework.io.UnsafeByteArrayOutputStream;
import io.basc.framework.io.UnsafeStringWriter;
import io.basc.framework.lang.Nullable;
import io.basc.framework.util.Assert;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.function.Consumer;

public final class IOUtils {
    private static final int EOF = -1;
    public static final char DIR_SEPARATOR_UNIX = '/';
    public static final char DIR_SEPARATOR_WINDOWS = '\\';
    public static final char DIR_SEPARATOR = File.separatorChar;
    public static final String LINE_SEPARATOR_UNIX = "\n";
    public static final String LINE_SEPARATOR_WINDOWS = "\r\n";
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final String LINE_SEPARATOR;
    private static final int DEFAULT_READ_BUFFER_SIZE = 256;
    private static final byte[] EMPTY_CONTENT;
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static char[] SKIP_CHAR_BUFFER;
    private static byte[] SKIP_BYTE_BUFFER;

    private IOUtils() {
    }

    public static InputStream limitedInputStream(InputStream is, long limit) {
        return new LimitedInputStream(is, limit);
    }

    public static InputStream markSupportedInputStream(final InputStream is, final int markBufferSize) {
        if (is.markSupported()) {
            return is;
        }
        return new InputStream(){
            byte[] mMarkBuffer;
            boolean mInMarked = false;
            boolean mInReset = false;
            private int mPosition = 0;
            private int mCount = 0;
            boolean mDry = false;

            @Override
            public int read() throws IOException {
                if (!this.mInMarked) {
                    return is.read();
                }
                if (this.mPosition < this.mCount) {
                    byte b = this.mMarkBuffer[this.mPosition++];
                    return b & 0xFF;
                }
                if (!this.mInReset) {
                    if (this.mDry) {
                        return -1;
                    }
                    if (null == this.mMarkBuffer) {
                        this.mMarkBuffer = new byte[markBufferSize];
                    }
                    if (this.mPosition >= markBufferSize) {
                        throw new IOException("Mark buffer is full!");
                    }
                    int read = is.read();
                    if (-1 == read) {
                        this.mDry = true;
                        return -1;
                    }
                    this.mMarkBuffer[this.mPosition++] = (byte)read;
                    ++this.mCount;
                    return read;
                }
                this.mInMarked = false;
                this.mInReset = false;
                this.mPosition = 0;
                this.mCount = 0;
                return is.read();
            }

            @Override
            public synchronized void mark(int readlimit) {
                this.mInMarked = true;
                this.mInReset = false;
                int count = this.mCount - this.mPosition;
                if (count > 0) {
                    System.arraycopy(this.mMarkBuffer, this.mPosition, this.mMarkBuffer, 0, count);
                    this.mCount = count;
                    this.mPosition = 0;
                }
            }

            @Override
            public synchronized void reset() throws IOException {
                if (!this.mInMarked) {
                    throw new IOException("should mark befor reset!");
                }
                this.mInReset = true;
                this.mPosition = 0;
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public int available() throws IOException {
                int available = is.available();
                if (this.mInMarked && this.mInReset) {
                    available += this.mCount - this.mPosition;
                }
                return available;
            }
        };
    }

    public static InputStream markSupportedInputStream(InputStream is) {
        return IOUtils.markSupportedInputStream(is, 1024);
    }

    public static void skipUnusedStream(InputStream is) throws IOException {
        if (is.available() > 0) {
            is.skip(is.available());
        }
    }

    public static long write(InputStream is, OutputStream os) throws IOException {
        return IOUtils.write(is, os, 4096);
    }

    public static long write(InputStream is, OutputStream os, int bufferSize) throws IOException {
        return IOUtils.copy(is, os, new byte[bufferSize]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(OutputStream os, String[] lines) throws IOException {
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(os));){
            for (String line : lines) {
                writer.println(line);
            }
            writer.flush();
        }
    }

    public static void writeLines(File file, String[] lines) throws IOException {
        if (file == null) {
            throw new IOException("File is null.");
        }
        IOUtils.writeLines(new FileOutputStream(file), lines);
    }

    public static void appendLines(File file, String[] lines) throws IOException {
        if (file == null) {
            throw new IOException("File is null.");
        }
        IOUtils.writeLines(new FileOutputStream(file, true), lines);
    }

    public static String read(Reader reader, int buffSize) throws IOException {
        int len;
        StringBuilder sb = new StringBuilder(buffSize);
        char[] buff = new char[buffSize];
        while ((len = reader.read(buff)) != -1) {
            sb.append(buff, 0, len);
        }
        return sb.toString();
    }

    public static String read(Reader reader) throws IOException {
        return IOUtils.read(reader, 256);
    }

    public static void close(Closeable closeable) throws IOException {
        if (closeable == null) {
            return;
        }
        closeable.close();
    }

    public static void close(Closeable ... closeables) throws IOException {
        if (closeables == null) {
            return;
        }
        IOException exception = null;
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static void closeQuietly(Closeable closeable) {
        IOUtils.closeQuietly(closeable, null);
    }

    public static void closeQuietly(Closeable closeable, Consumer<IOException> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (consumer == null) break block3;
                    consumer.accept(e);
                }
            }
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            IOUtils.closeQuietly(closeable);
        }
    }

    public static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static byte[] toByteArray(InputStream input) throws IOException {
        if (input instanceof UnsafeByteArrayInputStream) {
            return ((UnsafeByteArrayInputStream)input).toByteArray();
        }
        UnsafeByteArrayOutputStream output = new UnsafeByteArrayOutputStream();
        IOUtils.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(InputStream input, long size) throws IOException {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + size);
        }
        return IOUtils.toByteArray(input, (int)size);
    }

    public static byte[] toByteArray(InputStream input, int size) throws IOException {
        int offset;
        int readed;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] data = new byte[size];
        for (offset = 0; offset < size && (readed = input.read(data, offset, size - offset)) != -1; offset += readed) {
        }
        if (offset != size) {
            throw new IOException("Unexpected readed size. current: " + offset + ", excepted: " + size);
        }
        return data;
    }

    public static byte[] toByteArray(Reader input) throws IOException {
        UnsafeByteArrayOutputStream output = new UnsafeByteArrayOutputStream();
        IOUtils.copy(input, (OutputStream)output);
        return output.toByteArray();
    }

    public static byte[] toByteArray(Reader input, String encoding) throws IOException {
        UnsafeByteArrayOutputStream output = new UnsafeByteArrayOutputStream();
        IOUtils.copy(input, (OutputStream)output, encoding);
        return output.toByteArray();
    }

    public static char[] toCharArray(InputStream is) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.copy(is, (Writer)output);
        return output.toCharArray();
    }

    public static char[] toCharArray(InputStream is, String encoding) throws IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.copy(is, (Writer)output, encoding);
        return output.toCharArray();
    }

    public static char[] toCharArray(Reader input) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IOUtils.copy(input, (Writer)sw);
        return sw.toCharArray();
    }

    public static String toString(InputStream input) throws IOException {
        return IOUtils.toString(input, null);
    }

    public static String toString(InputStream input, @Nullable String encoding) throws IOException {
        UnsafeByteArrayOutputStream out = new UnsafeByteArrayOutputStream();
        IOUtils.copy(input, (OutputStream)out);
        return StringUtils.hasText(encoding) ? out.toString(encoding) : out.toString();
    }

    public static String toString(URI uri) throws IOException {
        return IOUtils.toString(uri, null);
    }

    public static String toString(URI uri, String encoding) throws IOException {
        return IOUtils.toString(uri.toURL(), encoding);
    }

    public static String toString(URL url) throws IOException {
        return IOUtils.toString(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(URL url, String encoding) throws IOException {
        try (InputStream inputStream = url.openStream();){
            String string = IOUtils.toString(inputStream, encoding);
            return string;
        }
    }

    public static Cursor<String> readLines(InputStream input) {
        InputStreamReader reader = new InputStreamReader(input);
        return IOUtils.readLines(reader).onClose(() -> IOUtils.closeQuietly((Closeable)reader));
    }

    public static Cursor<String> readLines(InputStream input, @Nullable String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return IOUtils.readLines(input);
        }
        InputStreamReader reader = new InputStreamReader(input, encoding);
        return IOUtils.readLines(reader).onClose(() -> IOUtils.closeQuietly((Closeable)reader));
    }

    public static Cursor<String> readLines(Reader reader) {
        if (reader instanceof BufferedReader) {
            return IOUtils.readLines((BufferedReader)reader);
        }
        BufferedReader bufferedReader = new BufferedReader(reader);
        return IOUtils.readLines(bufferedReader).onClose(() -> IOUtils.closeQuietly((Closeable)bufferedReader));
    }

    public static Cursor<String> readLines(BufferedReader bufferedReader) {
        LineIterator iterator = new LineIterator(bufferedReader);
        return Cursor.of(iterator);
    }

    public static InputStream toInputStream(CharSequence input) {
        return IOUtils.toInputStream(input.toString());
    }

    public static InputStream toInputStream(CharSequence input, String encoding) throws IOException {
        return IOUtils.toInputStream(input.toString(), encoding);
    }

    public static InputStream toInputStream(String input) {
        byte[] bytes = input.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public static InputStream toInputStream(String input, String encoding) throws IOException {
        byte[] bytes = encoding != null ? input.getBytes(encoding) : input.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void write(byte[] data, Writer output) throws IOException {
        if (data != null) {
            output.write(new String(data));
        }
    }

    public static void write(byte[] data, Writer output, String encoding) throws IOException {
        if (data != null) {
            if (encoding == null) {
                IOUtils.write(data, output);
            } else {
                output.write(new String(data, encoding));
            }
        }
    }

    public static void write(char[] data, Writer output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void write(char[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(new String(data).getBytes());
        }
    }

    public static void write(char[] data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            if (encoding == null) {
                IOUtils.write(data, output);
            } else {
                output.write(new String(data).getBytes(encoding));
            }
        }
    }

    public static void write(CharSequence data, Writer output) throws IOException {
        if (data != null) {
            IOUtils.write(data.toString(), output);
        }
    }

    public static void write(CharSequence data, OutputStream output) throws IOException {
        if (data != null) {
            IOUtils.write(data.toString(), output);
        }
    }

    public static void write(CharSequence data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            IOUtils.write(data.toString(), output, encoding);
        }
    }

    public static void write(String data, Writer output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void write(String data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data.getBytes());
        }
    }

    public static void write(String data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            if (encoding == null) {
                IOUtils.write(data, output);
            } else {
                output.write(data.getBytes(encoding));
            }
        }
    }

    public static void writeLines(Collection<?> lines, String lineEnding, OutputStream output) throws IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        for (Object line : lines) {
            if (line != null) {
                output.write(line.toString().getBytes());
            }
            output.write(lineEnding.getBytes());
        }
    }

    public static void writeLines(Collection<?> lines, String lineEnding, OutputStream output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.writeLines(lines, lineEnding, output);
        } else {
            if (lines == null) {
                return;
            }
            if (lineEnding == null) {
                lineEnding = LINE_SEPARATOR;
            }
            for (Object line : lines) {
                if (line != null) {
                    output.write(line.toString().getBytes(encoding));
                }
                output.write(lineEnding.getBytes(encoding));
            }
        }
    }

    public static void writeLines(Collection<?> lines, String lineEnding, Writer writer) throws IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = LINE_SEPARATOR;
        }
        for (Object line : lines) {
            if (line != null) {
                writer.write(line.toString());
            }
            writer.write(lineEnding);
        }
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copy(input, output, new byte[4096]);
    }

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, OutputStream output, long inputOffset, long length) throws IOException {
        return IOUtils.copy(input, output, inputOffset, length, new byte[4096]);
    }

    public static long copy(InputStream input, OutputStream output, long inputOffset, long length, byte[] buffer) throws IOException {
        int read;
        int bufferLength;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = bufferLength = buffer.length;
        if (length > 0L && length < (long)bufferLength) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read = input.read(buffer, 0, bytesToRead))) {
            output.write(buffer, 0, read);
            totalRead += (long)read;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)bufferLength);
        }
        return totalRead;
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtils.copy((Reader)in, output);
    }

    public static void copy(InputStream input, Writer output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.copy(input, output);
        } else {
            InputStreamReader in = new InputStreamReader(input, encoding);
            IOUtils.copy((Reader)in, output);
        }
    }

    public static long copy(Reader input, Writer output) throws IOException {
        return IOUtils.copy(input, output, new char[4096]);
    }

    public static long copy(Reader input, Writer output, char[] buffer) throws IOException {
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(Reader input, Writer output, long inputOffset, long length) throws IOException {
        return IOUtils.copy(input, output, inputOffset, length, new char[4096]);
    }

    public static long copy(Reader input, Writer output, long inputOffset, long length, char[] buffer) throws IOException {
        int read;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = buffer.length;
        if (length > 0L && length < (long)buffer.length) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read = input.read(buffer, 0, bytesToRead))) {
            output.write(buffer, 0, read);
            totalRead += (long)read;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)buffer.length);
        }
        return totalRead;
    }

    public static void copy(Reader input, OutputStream output) throws IOException {
        OutputStreamWriter out = new OutputStreamWriter(output);
        IOUtils.copy(input, (Writer)out);
        out.flush();
    }

    public static void copy(Reader input, OutputStream output, String encoding) throws IOException {
        if (encoding == null) {
            IOUtils.copy(input, output);
        } else {
            OutputStreamWriter out = new OutputStreamWriter(output, encoding);
            IOUtils.copy(input, (Writer)out);
            out.flush();
        }
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws IOException {
        int ch2;
        input1 = IOUtils.toBufferedReader(input1);
        input2 = IOUtils.toBufferedReader(input2);
        int ch = input1.read();
        while (-1 != ch) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws IOException {
        BufferedReader br1 = IOUtils.toBufferedReader(input1);
        BufferedReader br2 = IOUtils.toBufferedReader(input2);
        String line1 = br1.readLine();
        String line2 = br2.readLine();
        while (line1 != null && line2 != null && line1.equals(line2)) {
            line1 = br1.readLine();
            line2 = br2.readLine();
        }
        return line1 == null ? line2 == null : line1.equals(line2);
    }

    public static long skip(InputStream input, long toSkip) throws IOException {
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (SKIP_BYTE_BUFFER == null) {
            SKIP_BYTE_BUFFER = new byte[2048];
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(SKIP_BYTE_BUFFER, 0, (int)Math.min(remain, 2048L))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static long skip(Reader input, long toSkip) throws IOException {
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (SKIP_CHAR_BUFFER == null) {
            SKIP_CHAR_BUFFER = new char[2048];
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(SKIP_CHAR_BUFFER, 0, (int)Math.min(remain, 2048L))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static void skipFully(InputStream input, long toSkip) throws IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(Reader input, long toSkip) throws IOException {
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Chars to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static <E extends Throwable> long read(ByteBuffer buffer, BufferProcessor<byte[], E> reader) throws E {
        return IOUtils.read(buffer, 4096, reader);
    }

    public static <E extends Throwable> long read(ByteBuffer buffer, int bufferSize, BufferProcessor<byte[], E> reader) throws E {
        Assert.isTrue(bufferSize > 0, "Buffersize needs to be greater than 0");
        if (reader == null) {
            return 0L;
        }
        if (buffer == null || !buffer.hasRemaining()) {
            return 0L;
        }
        if (buffer.hasArray()) {
            byte[] b = buffer.array();
            int ofs = buffer.arrayOffset();
            int pos = buffer.position();
            int lim = buffer.limit();
            reader.process(b, ofs + pos, lim - pos);
            buffer.position(lim);
            return lim - pos;
        }
        int len = buffer.remaining();
        int n = Math.min(len, bufferSize);
        byte[] tempArray = new byte[n];
        long size = 0L;
        while (len > 0) {
            int chunk = Math.min(len, tempArray.length);
            buffer.get(tempArray, 0, chunk);
            reader.process(tempArray, 0, chunk);
            len -= chunk;
            size += (long)chunk;
        }
        return size;
    }

    public static <E extends Throwable> long read(InputStream input, BufferProcessor<byte[], E> reader) throws E, IOException {
        return IOUtils.read(input, 4096, reader);
    }

    public static <E extends Throwable> long read(InputStream input, int bufferSize, BufferProcessor<byte[], E> reader) throws E, IOException {
        Assert.isTrue(bufferSize > 0, "Buffersize needs to be greater than 0");
        if (reader == null || input == null) {
            return 0L;
        }
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            reader.process(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static int read(Reader input, char[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    public static int read(Reader input, char[] buffer) throws IOException {
        return IOUtils.read(input, buffer, 0, buffer.length);
    }

    public static int read(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    public static int read(InputStream input, byte[] buffer) throws IOException {
        return IOUtils.read(input, buffer, 0, buffer.length);
    }

    public static void readFully(Reader input, char[] buffer, int offset, int length) throws IOException {
        int actual = IOUtils.read(input, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static void readFully(Reader input, char[] buffer) throws IOException {
        IOUtils.readFully(input, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        int actual = IOUtils.read(input, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static void readFully(InputStream input, byte[] buffer) throws IOException {
        IOUtils.readFully(input, buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readContent(InputStream inputStream, int buffSize, String charsetName) throws IOException {
        String string;
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(inputStream, charsetName);
            string = IOUtils.read((Reader)isr, buffSize);
        }
        catch (Throwable throwable) {
            IOUtils.close(isr);
            throw throwable;
        }
        IOUtils.close((Closeable)isr);
        return string;
    }

    public static String readContent(InputStream inputStream, String charsetName) throws IOException {
        return IOUtils.readContent(inputStream, 256, charsetName);
    }

    public static byte[] copyToByteArray(InputStream in) throws IOException {
        return IOUtils.copyToByteArray(in, 4096);
    }

    public static byte[] copyToByteArray(InputStream in, int bufferSize) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        if (in instanceof UnsafeByteArrayInputStream) {
            return ((UnsafeByteArrayInputStream)in).toByteArray();
        }
        UnsafeByteArrayOutputStream out = new UnsafeByteArrayOutputStream(bufferSize);
        IOUtils.copy(in, (OutputStream)out, new byte[bufferSize]);
        return out.toByteArray();
    }

    public static String copyToString(InputStream in, Charset charset) throws IOException {
        if (in == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, charset);
        char[] buffer = new char[4096];
        int bytesRead = -1;
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        Assert.notNull((Object)in, "No input byte array specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        out.write(in);
    }

    public static void copy(String in, Charset charset, OutputStream out) throws IOException {
        Assert.notNull((Object)in, "No input String specified");
        Assert.notNull((Object)charset, "No charset specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        writer.write(in);
        ((Writer)writer).flush();
    }

    public static long copyRange(InputStream in, OutputStream out, long start, long end) throws IOException {
        int bytesRead;
        Assert.notNull((Object)in, "No InputStream specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        long skipped = in.skip(start);
        if (skipped < start) {
            throw new IOException("Skipped only " + skipped + " bytes out of " + start + " required");
        }
        long bytesToCopy = end - start + 1L;
        byte[] buffer = new byte[4096];
        while (bytesToCopy > 0L && (bytesRead = in.read(buffer)) != -1) {
            if ((long)bytesRead <= bytesToCopy) {
                out.write(buffer, 0, bytesRead);
                bytesToCopy -= (long)bytesRead;
                continue;
            }
            out.write(buffer, 0, (int)bytesToCopy);
            bytesToCopy = 0L;
        }
        return end - start + 1L - bytesToCopy;
    }

    public static long drain(InputStream in) throws IOException {
        Assert.notNull((Object)in, "No InputStream specified");
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        long byteCount = 0L;
        while ((bytesRead = in.read(buffer)) != -1) {
            byteCount += (long)bytesRead;
        }
        return byteCount;
    }

    public static InputStream emptyInput() {
        return new ByteArrayInputStream(EMPTY_CONTENT);
    }

    public static InputStream nonClosing(InputStream in) {
        Assert.notNull((Object)in, "No InputStream specified");
        return new NonClosingInputStream(in);
    }

    public static OutputStream nonClosing(OutputStream out) {
        Assert.notNull((Object)out, "No OutputStream specified");
        return new NonClosingOutputStream(out);
    }

    static {
        UnsafeStringWriter buf = new UnsafeStringWriter(4);
        PrintWriter out = new PrintWriter(buf);
        out.println();
        LINE_SEPARATOR = buf.toString();
        out.close();
        EMPTY_CONTENT = new byte[0];
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        public NonClosingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int let) throws IOException {
            this.out.write(b, off, let);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

