/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.codec.support.Base64;
import io.basc.framework.io.FileUtils;
import io.basc.framework.util.StringUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class ImageUtils {
    private ImageUtils() {
    }

    public static void scale(String imagePath, String newImagePath, int newWidth, int newHeight) {
        try {
            BufferedImage oldImg = ImageIO.read(new File(imagePath));
            Image image = oldImg.getScaledInstance(newWidth, newHeight, 1);
            BufferedImage newImg = new BufferedImage(newWidth, newHeight, 1);
            Graphics g = newImg.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)newImg, ImageUtils.getFormatName(imagePath), new File(newImagePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getFormatName(String imagePath) {
        return imagePath.substring(imagePath.lastIndexOf(".") + 1).toUpperCase();
    }

    public static void cut(String oldImagePath, String newImagePath, int x, int y, int width, int height, boolean isFill) {
        try {
            BufferedImage oldImage = ImageIO.read(new File(oldImagePath));
            int oldwidth = oldImage.getWidth();
            int oldHeight = oldImage.getHeight();
            if (oldwidth == 0 || oldHeight == 0) {
                return;
            }
            if (isFill) {
                if (width > oldwidth) {
                    oldwidth = width;
                }
                if (height > oldHeight) {
                    oldHeight = height;
                }
            }
            Image image = oldImage.getScaledInstance(oldwidth, oldHeight, 1);
            BufferedImage newImage = new BufferedImage(width, height, 1);
            Graphics g = newImage.getGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)newImage, ImageUtils.getFormatName(oldImagePath), new File(newImagePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cut2(String imgPath, String descDir, int rows, int cols) {
        try {
            if (rows <= 0 || cols <= 0) {
                return;
            }
            BufferedImage img = ImageIO.read(new File(imgPath));
            int width = img.getWidth();
            int height = img.getHeight();
            if (width <= 0 || height <= 0) {
                return;
            }
            if (rows > height || cols > width) {
                return;
            }
            Image tempImage = img.getScaledInstance(width, height, 1);
            int destWidth = width / cols;
            int destHeight = height / rows;
            String formateName = ImageUtils.getFormatName(imgPath);
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    int newImageW = destWidth;
                    int newImageH = destHeight;
                    if (j == cols - 1) {
                        newImageW = width - destWidth * j;
                    }
                    if (i == rows - 1) {
                        newImageH = height - destHeight * i;
                    }
                    CropImageFilter cropFilter = new CropImageFilter(j * destWidth, i * destHeight, newImageW, newImageH);
                    Image image = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(tempImage.getSource(), cropFilter));
                    BufferedImage tag = new BufferedImage(newImageW, newImageH, 1);
                    Graphics g = tag.getGraphics();
                    g.drawImage(image, 0, 0, null);
                    g.dispose();
                    ImageIO.write((RenderedImage)tag, formateName, new File(descDir + i + "_" + j + "." + formateName.toLowerCase()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void convert(String oldImagePath, String newImagePath) {
        try {
            BufferedImage img = ImageIO.read(new File(oldImagePath));
            ImageIO.write((RenderedImage)img, ImageUtils.getFormatName(newImagePath), new File(newImagePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void gray(String imagePath, String newImagePath) {
        try {
            BufferedImage oldBi = ImageIO.read(new File(imagePath));
            ColorSpace cs = ColorSpace.getInstance(1003);
            ColorConvertOp ccop = new ColorConvertOp(cs, null);
            oldBi = ccop.filter(oldBi, null);
            ImageIO.write((RenderedImage)oldBi, ImageUtils.getFormatName(imagePath), new File(newImagePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pressText(String pressText, String imagePath, String newImagePath, String fontName, int fontStyle, Color color, int fontSize, int x, int y, float alpha) {
        try {
            BufferedImage img = ImageIO.read(new File(imagePath));
            int width = ((Image)img).getWidth(null);
            int height = ((Image)img).getHeight(null);
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(img, 0, 0, width, height, null);
            g.setColor(color);
            g.setFont(new Font(fontName, fontStyle, fontSize));
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawString(pressText, (width - ImageUtils.getLength(pressText) * fontSize) / 2 + x, (height - fontSize) / 2 + y);
            g.dispose();
            ImageIO.write((RenderedImage)image, ImageUtils.getFormatName(imagePath), new File(newImagePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pressImage(String pressImg, String srcImageFile, String destImageFile, int x, int y, float alpha) {
        try {
            File img = new File(srcImageFile);
            BufferedImage src = ImageIO.read(img);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            BufferedImage src_biao = ImageIO.read(new File(pressImg));
            int wideth_biao = ((Image)src_biao).getWidth(null);
            int height_biao = ((Image)src_biao).getHeight(null);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawImage(src_biao, (wideth - wideth_biao) / 2, (height - height_biao) / 2, wideth_biao, height_biao, null);
            g.dispose();
            ImageIO.write((RenderedImage)image, ImageUtils.getFormatName(srcImageFile), new File(destImageFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getLength(String text) {
        int length = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (new String(text.charAt(i) + "").getBytes().length > 1) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length / 2;
    }

    public static String getBase64ImageUrl(String filePath) {
        byte[] data;
        StringBuilder sb = new StringBuilder("data:image/jpg;base64,");
        sb.append("data:image/");
        sb.append(StringUtils.getFilenameExtension(filePath));
        sb.append(";base64,");
        try {
            data = FileUtils.readFileToByteArray(new File(filePath));
        }
        catch (IOException e) {
            throw new RuntimeException(filePath, e);
        }
        return Base64.DEFAULT.encode(data);
    }
}

