/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.FileUtils;
import io.basc.framework.io.IOUtils;
import io.basc.framework.util.ConsumeProcessor;
import io.basc.framework.util.Processor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;

@FunctionalInterface
public interface InputStreamSource {
    public InputStream getInputStream() throws IOException;

    default public ReadableByteChannel readableChannel() throws IOException {
        return Channels.newChannel(this.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T, E extends Throwable> T read(Processor<? super InputStream, ? extends T, ? extends E> processor) throws IOException, E {
        try (InputStream is = null;){
            is = this.getInputStream();
            T t = processor.process(is);
            return t;
        }
    }

    default public <E extends Throwable> void consume(ConsumeProcessor<? super InputStream, ? extends E> processor) throws IOException, E {
        this.read(is -> {
            processor.process((InputStream)is);
            return null;
        });
    }

    default public byte[] getBytes() throws IOException {
        return this.read(is -> IOUtils.toByteArray(is));
    }

    default public void transferTo(File dest) throws IOException, IllegalStateException {
        this.consume(is -> FileUtils.copyInputStreamToFile(is, dest));
    }

    default public void transferTo(Path dest) throws IOException, IllegalStateException {
        this.consume(is -> FileUtils.copyInputStreamToPath(is, dest));
    }
}

