/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.IterationFile;
import io.basc.framework.lang.Nullable;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ListFileIterator
implements Iterator<IterationFile<File>> {
    private final File directory;
    private final FileFilter fileFilter;
    private final int depth;
    private final int maxDepth;
    private File[] files;
    private Iterator<File> directoryIterator;
    private Iterator<IterationFile<File>> iterator;

    public ListFileIterator(File directory, @Nullable FileFilter fileFilter, int maxDepth) {
        this(directory, fileFilter, maxDepth, 0);
    }

    private ListFileIterator(File directory, FileFilter fileFilter, int maxDepth, int depth) {
        this.directory = directory;
        this.fileFilter = fileFilter;
        this.maxDepth = maxDepth;
        this.depth = depth;
    }

    public File getDirectory() {
        return this.directory;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean canRecursive(int depth) {
        if (this.maxDepth < 0) {
            return true;
        }
        return depth <= this.maxDepth;
    }

    @Override
    public boolean hasNext() {
        if (!this.canRecursive(this.depth)) {
            return false;
        }
        if (this.files == null) {
            File[] fileArray = this.files = this.fileFilter == null ? this.directory.listFiles() : this.directory.listFiles(this.fileFilter);
        }
        if (this.iterator == null) {
            this.iterator = Arrays.asList(this.files).stream().map(file -> new IterationFile<File>(this.depth, (File)file, this.directory)).iterator();
        }
        if (this.iterator.hasNext()) {
            return true;
        }
        if (!this.canRecursive(this.depth)) {
            return false;
        }
        if (this.directoryIterator == null) {
            this.directoryIterator = Arrays.asList(this.files).stream().filter(file -> file.isDirectory()).iterator();
        }
        if (this.directoryIterator.hasNext()) {
            this.iterator = new ListFileIterator(this.directoryIterator.next(), this.fileFilter, this.maxDepth, this.depth + 1);
            return this.hasNext();
        }
        return false;
    }

    @Override
    public IterationFile<File> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(this.toString());
        }
        return this.iterator.next();
    }

    public String toString() {
        return "maxDepth:" + this.maxDepth + ", depth:" + this.depth + ", directory:" + this.directory;
    }
}

