/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.IterationFile;
import io.basc.framework.lang.Nullable;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ListFilenameIterator
implements Iterator<IterationFile<String>> {
    private final File directory;
    private final FilenameFilter fileFilter;
    private final int depth;
    private final int maxDepth;
    private String[] files;
    private Iterator<File> directoryIterator;
    private Iterator<IterationFile<String>> iterator;

    public ListFilenameIterator(File directory, @Nullable FilenameFilter fileFilter, int maxDepth) {
        this(directory, fileFilter, maxDepth, 0);
    }

    private ListFilenameIterator(File directory, FilenameFilter fileFilter, int maxDepth, int depth) {
        this.directory = directory;
        this.fileFilter = fileFilter;
        this.maxDepth = maxDepth;
        this.depth = depth;
    }

    public boolean canRecursive(int depth) {
        if (this.maxDepth < 0) {
            return true;
        }
        return depth <= this.maxDepth;
    }

    public File getDirectory() {
        return this.directory;
    }

    public FilenameFilter getFileFilter() {
        return this.fileFilter;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    @Override
    public boolean hasNext() {
        if (!this.canRecursive(this.depth)) {
            return false;
        }
        if (this.files == null) {
            String[] stringArray = this.files = this.fileFilter == null ? this.directory.list() : this.directory.list(this.fileFilter);
        }
        if (this.iterator == null) {
            this.iterator = Arrays.asList(this.files).stream().map(name -> new IterationFile<String>(this.depth, (String)name, this.directory)).iterator();
        }
        if (this.iterator.hasNext()) {
            return true;
        }
        if (!this.canRecursive(this.depth)) {
            return false;
        }
        if (this.directoryIterator == null) {
            this.directoryIterator = Arrays.asList(this.files).stream().map(name -> new File(this.directory, (String)name)).filter(file -> file.isDirectory()).iterator();
        }
        if (this.directoryIterator.hasNext()) {
            this.iterator = new ListFilenameIterator(this.directoryIterator.next(), this.fileFilter, this.maxDepth, this.depth + 1);
            return this.hasNext();
        }
        return false;
    }

    @Override
    public IterationFile<String> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException(this.toString());
        }
        return this.iterator.next();
    }

    public String toString() {
        return "maxDepth:" + this.maxDepth + ", depth:" + this.depth + ", directory:" + this.directory;
    }
}

