/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.codec.DecodeException;
import io.basc.framework.codec.support.RecordCodec;
import io.basc.framework.io.IOUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.CloseableIterator;
import io.basc.framework.util.Source;
import io.basc.framework.util.StaticSupplier;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.function.Supplier;

public final class RecordIterator<E>
implements CloseableIterator<E> {
    private final Source<? extends InputStream, ? extends IOException> source;
    private final RecordCodec<E> codec;
    private volatile InputStream inputStream;
    private volatile Supplier<E> supplier;

    public RecordIterator(File file, RecordCodec<E> codec) {
        this(() -> new FileInputStream(file), codec);
    }

    public RecordIterator(Source<? extends InputStream, ? extends IOException> source, RecordCodec<E> codec) {
        Assert.requiredArgument(source != null, "source");
        Assert.requiredArgument(codec != null, "codec");
        this.source = source;
        this.codec = codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            RecordIterator recordIterator = this;
            synchronized (recordIterator) {
                if (this.inputStream == null) {
                    this.inputStream = this.source.get();
                }
            }
        }
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.inputStream != null) {
            RecordIterator recordIterator = this;
            synchronized (recordIterator) {
                if (this.inputStream != null) {
                    try {
                        IOUtils.closeQuietly((Closeable)this.inputStream);
                    }
                    finally {
                        this.inputStream = null;
                    }
                }
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.supplier == null) {
            try {
                this.supplier = new StaticSupplier(this.codec.decode(this.getInputStream()));
            }
            catch (EOFException e) {
                this.close();
                return false;
            }
            catch (RuntimeException e) {
                this.close();
                throw e;
            }
            catch (Throwable e) {
                this.close();
                throw new DecodeException(e);
            }
        }
        return true;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            E e = this.supplier.get();
            return e;
        }
        finally {
            this.supplier = null;
        }
    }
}

