/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.event.EventListener;
import io.basc.framework.event.Observable;
import io.basc.framework.event.ObservableChangeEvent;
import io.basc.framework.io.InputStreamSource;
import io.basc.framework.lang.NotFoundException;
import io.basc.framework.lang.UnsupportedException;
import io.basc.framework.util.Processor;
import io.basc.framework.util.Registration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public interface Resource
extends InputStreamSource,
Observable<Resource> {
    public boolean exists();

    default public boolean isReadable() {
        return this.exists();
    }

    default public boolean isOpen() {
        return false;
    }

    public URL getURL() throws IOException;

    public URI getURI() throws IOException;

    default public boolean isFile() {
        return false;
    }

    public File getFile() throws IOException, FileNotFoundException;

    public long contentLength() throws IOException;

    public long lastModified() throws IOException;

    public Resource createRelative(String var1) throws IOException;

    public String getName();

    public String getDescription();

    @Override
    default public boolean isPresent() {
        return this.exists();
    }

    @Override
    default public Registration registerListener(EventListener<ObservableChangeEvent<Resource>> eventListener) {
        return Registration.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    default public <T, E extends Throwable> T read(Processor<? super InputStream, ? extends T, ? extends E> processor) throws IOException, E {
        if (!this.exists()) {
            throw new NotFoundException("not found: " + this.getDescription());
        }
        if (!this.isReadable()) {
            throw new UnsupportedException("not read: " + this.getDescription());
        }
        InputStream is = null;
        try {
            is = this.getInputStream();
            T t = processor.process(is);
            return t;
        }
        finally {
            if (is != null && !this.isOpen()) {
                is.close();
            }
        }
    }
}

