/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.io;

import io.basc.framework.io.IOUtils;
import io.basc.framework.io.NonexistentResource;
import io.basc.framework.io.Resource;
import io.basc.framework.io.UnsafeByteArrayInputStream;
import io.basc.framework.io.UrlResource;
import io.basc.framework.io.resolver.PropertiesResolver;
import io.basc.framework.lang.NestedRuntimeException;
import io.basc.framework.lang.Nullable;
import io.basc.framework.net.InetUtils;
import io.basc.framework.util.ArrayUtils;
import io.basc.framework.util.Assert;
import io.basc.framework.util.ClassUtils;
import io.basc.framework.util.Cursor;
import io.basc.framework.util.StringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;

public final class ResourceUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String URL_PROTOCOL_RSRC = "rsrc";
    public static final String RSRC_URL_PREFIX = "rsrc:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String URL_PROTOCOL_WAR = "war";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_FILE_EXTENSION = ".jar";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";
    public static final String META_INF_PREFIX = "META-INF/";
    public static final Resource NONEXISTENT_RESOURCE;
    private static final String[] RESOURCE_PREFIXS;

    private ResourceUtils() {
    }

    public static boolean isUrl(@Nullable String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            return true;
        }
        return InetUtils.isUrl(resourceLocation);
    }

    public static URL getURL(String resourceLocation) throws FileNotFoundException {
        Assert.notNull((Object)resourceLocation, "Resource location must not be null");
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            URL url;
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            ClassLoader cl = ClassUtils.getDefaultClassLoader();
            URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                String description = "class path resource [" + path + "]";
                throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
            }
            return url;
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new File(resourceLocation).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is neither a URL not a well-formed file path");
            }
        }
    }

    public static File getFile(String resourceLocation) throws FileNotFoundException {
        Assert.notNull((Object)resourceLocation, "Resource location must not be null");
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            URL url;
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            String description = "class path resource [" + path + "]";
            ClassLoader cl = ClassUtils.getDefaultClassLoader();
            URL uRL = url = cl != null ? cl.getResource(path) : ClassLoader.getSystemResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not exist");
            }
            return ResourceUtils.getFile(url, description);
        }
        try {
            return ResourceUtils.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    public static File getFile(URL resourceUrl) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUrl, "URL");
    }

    public static File getFile(URL resourceUrl, String description) throws FileNotFoundException {
        Assert.notNull((Object)resourceUrl, "Resource URL must not be null");
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUrl);
        }
        try {
            return new File(ResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    public static File getFile(URI resourceUri) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUri, "URI");
    }

    public static File getFile(URI resourceUri, String description) throws FileNotFoundException {
        Assert.notNull((Object)resourceUri, "Resource URI must not be null");
        if (!URL_PROTOCOL_FILE.equals(resourceUri.getScheme())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUri);
        }
        return new File(resourceUri.getSchemeSpecificPart());
    }

    public static boolean isFileURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_WAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol);
    }

    public static boolean isJarFileURL(URL url) {
        return URL_PROTOCOL_FILE.equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(JAR_FILE_EXTENSION);
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                if (!jarFile.startsWith("/")) {
                    jarFile = "/" + jarFile;
                }
                return new URL(FILE_URL_PREFIX + jarFile);
            }
        }
        return jarUrl;
    }

    public static URL extractArchiveURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int endIndex = urlFile.indexOf(WAR_URL_SEPARATOR);
        if (endIndex != -1) {
            String warFile = urlFile.substring(0, endIndex);
            if (URL_PROTOCOL_WAR.equals(jarUrl.getProtocol())) {
                return new URL(warFile);
            }
            int startIndex = warFile.indexOf(WAR_URL_PREFIX);
            if (startIndex != -1) {
                return new URL(warFile.substring(startIndex + WAR_URL_PREFIX.length()));
            }
        }
        return ResourceUtils.extractJarFileURL(jarUrl);
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace(location, " ", "%20"));
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
    }

    private static String cleanClassLoaderResourceName(String name) {
        String nameToUse = name;
        while (nameToUse.length() != 0 && nameToUse.startsWith("/")) {
            nameToUse = nameToUse.substring(1);
        }
        return nameToUse;
    }

    public static URL getResource(ClassLoader classLoader, String name) {
        String nameToUse = ResourceUtils.cleanClassLoaderResourceName(name);
        URL url = classLoader.getResource(nameToUse);
        if (url == null) {
            for (String prefix : RESOURCE_PREFIXS) {
                if (!nameToUse.startsWith(prefix) && (url = classLoader.getResource(prefix + nameToUse)) != null) break;
            }
        }
        return url;
    }

    public static URL getResource(Class<?> clazz, String name) {
        if (clazz == null || name == null) {
            return null;
        }
        String nameToUse = ResourceUtils.cleanClassLoaderResourceName(name);
        URL url = clazz.getResource(nameToUse);
        if (url == null) {
            for (String prefix : RESOURCE_PREFIXS) {
                if (!nameToUse.startsWith(prefix) && (url = clazz.getResource(prefix + nameToUse)) != null) break;
            }
        }
        if (url == null) {
            url = ResourceUtils.getResource(clazz.getClassLoader(), nameToUse);
        }
        return url;
    }

    public static InputStream getResourceAsStream(ClassLoader classLoader, String name) {
        if (classLoader == null || name == null) {
            return null;
        }
        String nameToUse = ResourceUtils.cleanClassLoaderResourceName(name);
        InputStream is = classLoader.getResourceAsStream(nameToUse);
        if (is == null) {
            for (String prefix : RESOURCE_PREFIXS) {
                if (!nameToUse.startsWith(prefix) && (is = classLoader.getResourceAsStream(prefix + nameToUse)) != null) break;
            }
        }
        return is;
    }

    public static InputStream getResourceAsStream(Class<?> clazz, String name) {
        if (clazz == null || name == null) {
            return null;
        }
        String nameToUse = ResourceUtils.cleanClassLoaderResourceName(name);
        InputStream is = clazz.getResourceAsStream(nameToUse);
        if (is == null) {
            for (String prefix : RESOURCE_PREFIXS) {
                if (!nameToUse.startsWith(prefix) && (is = clazz.getResourceAsStream(prefix + nameToUse)) != null) break;
            }
        }
        if (is == null) {
            is = ResourceUtils.getResourceAsStream(clazz.getClassLoader(), nameToUse);
        }
        return is;
    }

    public static Enumeration<URL> getResources(ClassLoader classLoader, String name) throws IOException {
        if (classLoader == null || name == null) {
            return Collections.emptyEnumeration();
        }
        String nameToUse = ResourceUtils.cleanClassLoaderResourceName(name);
        Enumeration<URL> urls = classLoader.getResources(nameToUse);
        if (urls == null || !urls.hasMoreElements()) {
            for (String prefix : RESOURCE_PREFIXS) {
                if (!nameToUse.startsWith(prefix) && (urls = classLoader.getResources(prefix + nameToUse)) != null && urls.hasMoreElements()) break;
            }
        }
        if (urls == null) {
            return Collections.emptyEnumeration();
        }
        return urls;
    }

    public static URL getSystemResource(@Nullable ClassLoader classLoader, String name) {
        String nameToUse;
        if (name == null) {
            return null;
        }
        URL url = ResourceUtils.getResource(classLoader, name);
        if (url == null && (url = ClassLoader.getSystemResource(nameToUse = ResourceUtils.cleanClassLoaderResourceName(name))) == null) {
            for (String prefix : RESOURCE_PREFIXS) {
                if (!nameToUse.startsWith(prefix) && (url = ClassLoader.getSystemResource(prefix + nameToUse)) != null) break;
            }
        }
        return url;
    }

    public static Enumeration<URL> getSystemResources(@Nullable ClassLoader classLoader, String name) throws IOException {
        String nameToUse;
        if (name == null) {
            return Collections.emptyEnumeration();
        }
        Enumeration<URL> urls = ResourceUtils.getResources(classLoader, name);
        if (!(urls != null && urls.hasMoreElements() || (urls = ClassLoader.getSystemResources(nameToUse = ResourceUtils.cleanClassLoaderResourceName(name))) != null && urls.hasMoreElements())) {
            for (String prefix : RESOURCE_PREFIXS) {
                if (!nameToUse.startsWith(prefix) && (urls = ClassLoader.getSystemResources(prefix + nameToUse)) != null && urls.hasMoreElements()) break;
            }
        }
        if (urls == null) {
            return Collections.emptyEnumeration();
        }
        return urls;
    }

    public static InputStream getSystemResourceAsStream(@Nullable ClassLoader classLoader, String name) {
        String nameToUse;
        if (name == null) {
            return null;
        }
        InputStream is = ResourceUtils.getResourceAsStream(classLoader, name);
        if (is == null && (is = ClassLoader.getSystemResourceAsStream(nameToUse = ResourceUtils.cleanClassLoaderResourceName(name))) == null) {
            for (String prefix : RESOURCE_PREFIXS) {
                if (!nameToUse.startsWith(prefix) && (is = ClassLoader.getSystemResourceAsStream(prefix + nameToUse)) != null) break;
            }
        }
        return is;
    }

    public static Resource getSystemResource(String name) {
        URL url = ResourceUtils.getSystemResource(ClassUtils.getDefaultClassLoader(), name);
        return url == null ? null : new UrlResource(url);
    }

    public static Resource[] getSystemResources(String name) throws IOException {
        Enumeration<URL> urls = ResourceUtils.getSystemResources(ClassUtils.getDefaultClassLoader(), name);
        List<Resource> resources = ResourceUtils.toUrlResources(urls);
        return resources.toArray(new Resource[0]);
    }

    public static List<Resource> toUrlResources(Enumeration<URL> urls) {
        if (urls == null || !urls.hasMoreElements()) {
            return Collections.emptyList();
        }
        ArrayList<Resource> list = new ArrayList<Resource>(8);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url == null) continue;
            list.add(new UrlResource(url));
        }
        return list;
    }

    public static Cursor<String> readLines(Resource resource, String charsetName) {
        if (resource == null || !resource.exists()) {
            return Cursor.empty();
        }
        try {
            InputStream is = resource.getInputStream();
            return IOUtils.readLines(is, charsetName).onClose(() -> {
                if (is != null && !resource.isOpen()) {
                    IOUtils.closeQuietly((Closeable)is);
                }
            });
        }
        catch (IOException iOException) {
            return Cursor.empty();
        }
    }

    public static Cursor<String> readLines(Resource resource, Charset charset) {
        return ResourceUtils.readLines(resource, charset.name());
    }

    @Nullable
    public static String getContent(Resource resource, String charsetName) {
        if (resource == null || !resource.exists()) {
            return null;
        }
        InputStream is = null;
        try {
            is = resource.getInputStream();
            String string = IOUtils.readContent(is, charsetName);
            return string;
        }
        catch (IOException e) {
            throw new NestedRuntimeException(resource.getDescription(), e);
        }
        finally {
            if (!resource.isOpen()) {
                IOUtils.closeQuietly((Closeable)is);
            }
        }
    }

    @Nullable
    public static String getContent(Resource resource, Charset charset) {
        return ResourceUtils.getContent(resource, charset.name());
    }

    @Nullable
    public static byte[] getBytes(Resource resource) {
        if (resource == null || !resource.exists()) {
            return null;
        }
        InputStream is = null;
        try {
            is = resource.getInputStream();
            byte[] byArray = IOUtils.toByteArray(is);
            return byArray;
        }
        catch (IOException e) {
            throw new NestedRuntimeException(resource.getDescription(), e);
        }
        finally {
            if (!resource.isOpen()) {
                IOUtils.closeQuietly((Closeable)is);
            }
        }
    }

    @Nullable
    public static UnsafeByteArrayInputStream getInputStream(Resource resource) {
        byte[] data = ResourceUtils.getBytes(resource);
        if (data == null) {
            return null;
        }
        return new UnsafeByteArrayInputStream(data);
    }

    public static Function<Resource, Properties> toPropertiesConverter(PropertiesResolver propertiesResolver) {
        return ResourceUtils.toPropertiesConverter(propertiesResolver, null);
    }

    public static Function<Resource, Properties> toPropertiesConverter(PropertiesResolver propertiesResolver, Charset charset) {
        return o -> {
            Properties properties = new Properties();
            propertiesResolver.resolveProperties(properties, (Resource)o, charset);
            return properties;
        };
    }

    static {
        String[] array;
        NONEXISTENT_RESOURCE = new NonexistentResource();
        String prefixs = System.getProperty("io.basc.framework.resource.prefixs");
        String[] resourcePrefixs = new String[]{"resources/"};
        if (StringUtils.isNotEmpty(prefixs) && (array = StringUtils.splitToArray(prefixs)) != null && array.length != 0) {
            resourcePrefixs = ArrayUtils.merge(array, resourcePrefixs);
        }
        for (int i = 0; i < resourcePrefixs.length; ++i) {
            String prefix = resourcePrefixs[i];
            while (prefix.endsWith("/")) {
                prefix = prefix.substring(0, prefix.length() - 2);
            }
            if (prefix.length() > 0) {
                prefix = prefix + "/";
            }
            resourcePrefixs[i] = prefix;
        }
        RESOURCE_PREFIXS = resourcePrefixs;
    }
}

